/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.loot.function;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import java.util.Set;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.block.entity.IRetexturedBlockEntity;
import slimeknights.mantle.loot.MantleLoot;
import slimeknights.mantle.util.RetexturedHelper;

public class RetexturedLootFunction
extends LootItemConditionalFunction {
    public static final Serializer SERIALIZER = new Serializer();

    public RetexturedLootFunction(LootItemCondition[] conditions) {
        super(conditions);
    }

    public RetexturedLootFunction() {
        super(new LootItemCondition[0]);
    }

    public Set<LootContextParam<?>> m_6231_() {
        return Set.of(LootContextParams.f_81462_);
    }

    protected ItemStack m_7372_(ItemStack stack, LootContext context) {
        BlockEntity te = (BlockEntity)context.m_78953_(LootContextParams.f_81462_);
        if (te instanceof IRetexturedBlockEntity) {
            IRetexturedBlockEntity retextured = (IRetexturedBlockEntity)te;
            RetexturedHelper.setTexture(stack, retextured.getTextureName());
        } else {
            String name = te == null ? "null" : te.getClass().getName();
            Mantle.logger.warn("Found wrong tile entity for loot function, expected IRetexturedTileEntity, found {}", (Object)name);
        }
        return stack;
    }

    public LootItemFunctionType m_7162_() {
        return MantleLoot.RETEXTURED_FUNCTION;
    }

    private static class Serializer
    extends LootItemConditionalFunction.Serializer<RetexturedLootFunction> {
        private Serializer() {
        }

        public RetexturedLootFunction deserialize(JsonObject json, JsonDeserializationContext ctx, LootItemCondition[] conditions) {
            return new RetexturedLootFunction(conditions);
        }
    }
}

