/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.lootjournal.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.obscuria.lootjournal.LootJournal;
import dev.obscuria.lootjournal.client.pickup.IPickupEntry;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public enum PickupDrawStyle {
    CLASSIC(PickupDrawStyle::renderClassic),
    FLAT(PickupDrawStyle::renderFlat),
    TEXT(PickupDrawStyle::renderText);

    private static final ResourceLocation DECORATIONS;
    private final Renderer renderer;

    private PickupDrawStyle(Renderer renderer) {
        this.renderer = renderer;
    }

    public void render(IPickupEntry pickup, GuiGraphics graphics, int y, double progress, long time) {
        Font font = Minecraft.m_91087_().f_91062_;
        MutableComponent name = pickup.getDisplayName();
        MutableComponent total = pickup.shouldDisplayTotalAmount() ? Component.m_237113_((String)String.valueOf(pickup.getTotalAmount())) : Component.m_237119_();
        int totalWidth = pickup.shouldDisplayTotalAmount() ? font.m_92852_((FormattedText)total) + 5 : 0;
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_85837_(PickupDrawStyle.getX(progress), (double)y, 100.0);
        RenderSystem.enableBlend();
        this.renderer.render(pickup, graphics, font, name, font.m_92852_((FormattedText)name), total, totalWidth, time);
        RenderSystem.disableBlend();
        graphics.m_280168_().m_85849_();
    }

    private static void renderClassic(IPickupEntry pickup, GuiGraphics graphics, Font font, MutableComponent name, int nameWidth, MutableComponent total, int totalWidth, long time) {
        if (PickupDrawStyle.isReversed()) {
            graphics.m_280163_(DECORATIONS, -36 - nameWidth - totalWidth, 0, 0.0f, 0.0f, 256, 12, 256, 256);
            graphics.m_280163_(DECORATIONS, -26 - totalWidth, 1, 0.0f, 12.0f, 256, 10, 256, 256);
            graphics.m_280430_(font, (Component)name, -29 - nameWidth - totalWidth, 2, 0xFFFFFF);
            graphics.m_280430_(font, (Component)total.m_130940_(ChatFormatting.GRAY), -totalWidth, 2, 0xFFFFFF);
            PickupDrawStyle.renderIcon(pickup, graphics, -11 - totalWidth, 6.0, time);
        } else {
            graphics.m_280163_(DECORATIONS, -218 + nameWidth + totalWidth, 0, 0.0f, 0.0f, 256, 12, 256, 256);
            graphics.m_280163_(DECORATIONS, -230 + totalWidth, 1, 0.0f, 12.0f, 256, 10, 256, 256);
            graphics.m_280430_(font, (Component)name, 30 + totalWidth, 2, 0xFFFFFF);
            graphics.m_280430_(font, (Component)total.m_130940_(ChatFormatting.GRAY), 5, 2, 0xFFFFFF);
            PickupDrawStyle.renderIcon(pickup, graphics, 11 + totalWidth, 6.0, time);
        }
    }

    private static void renderFlat(IPickupEntry pickup, GuiGraphics graphics, Font font, MutableComponent name, int nameWidth, MutableComponent total, int totalWidth, long time) {
        if (PickupDrawStyle.isReversed()) {
            graphics.m_280509_(-3, 0, -25 - nameWidth - totalWidth, 12, Integer.MIN_VALUE);
            graphics.m_280430_(font, (Component)name, -23 - nameWidth - totalWidth, 2, 0xFFFFFF);
            graphics.m_280430_(font, (Component)total.m_130940_(ChatFormatting.GRAY), -totalWidth, 2, 0xFFFFFF);
            PickupDrawStyle.renderIcon(pickup, graphics, -11 - totalWidth, 6.0, time);
        } else {
            graphics.m_280509_(3, 0, 25 + nameWidth + totalWidth, 12, Integer.MIN_VALUE);
            graphics.m_280430_(font, (Component)name, 23 + totalWidth, 2, 0xFFFFFF);
            graphics.m_280430_(font, (Component)total.m_130940_(ChatFormatting.GRAY), 5, 2, 0xFFFFFF);
            PickupDrawStyle.renderIcon(pickup, graphics, 11 + totalWidth, 6.0, time);
        }
    }

    private static void renderText(IPickupEntry pickup, GuiGraphics graphics, Font font, MutableComponent name, int nameWidth, MutableComponent total, int totalWidth, long time) {
        if (PickupDrawStyle.isReversed()) {
            graphics.m_280430_(font, (Component)name, -23 - nameWidth - totalWidth, 2, 0xFFFFFF);
            graphics.m_280430_(font, (Component)total.m_130940_(ChatFormatting.GRAY), -totalWidth, 2, 0xFFFFFF);
            PickupDrawStyle.renderIcon(pickup, graphics, -11 - totalWidth, 6.0, time);
        } else {
            graphics.m_280430_(font, (Component)name, 23 + totalWidth, 2, 0xFFFFFF);
            graphics.m_280430_(font, (Component)total.m_130940_(ChatFormatting.GRAY), 5, 2, 0xFFFFFF);
            PickupDrawStyle.renderIcon(pickup, graphics, 11 + totalWidth, 6.0, time);
        }
    }

    private static void renderIcon(IPickupEntry pickup, GuiGraphics graphics, double x, double y, long time) {
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_85837_(x, y, 0.0);
        pickup.renderIcon(graphics, time);
        graphics.m_280168_().m_85849_();
    }

    private static double getX(double progress) {
        double offset = -220.0 + 220.0 * (1.0 - Math.pow(progress - 1.0, 2.0));
        return PickupDrawStyle.isReversed() ? -offset : offset;
    }

    private static boolean isReversed() {
        return LootJournal.CONFIG.anchor.isReversed();
    }

    static {
        DECORATIONS = LootJournal.key("textures/gui/decorations.png");
    }

    @FunctionalInterface
    private static interface Renderer {
        public void render(IPickupEntry var1, GuiGraphics var2, Font var3, MutableComponent var4, int var5, MutableComponent var6, int var7, long var8);
    }
}

