/*
 * Decompiled with CFR 0.152.
 */
package com.github.L_Ender.cataclysm.entity.InternalAnimationMonster.AcropolisMonsters;

import com.github.L_Ender.cataclysm.entity.InternalAnimationMonster.AcropolisMonsters.Symbiocto_Entity;
import com.github.L_Ender.cataclysm.init.ModEntities;
import com.github.L_Ender.cataclysm.init.ModTag;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.ZombieAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class Drowned_Host_Entity
extends Zombie
implements RangedAttackMob {
    public static final float NAUTILUS_SHELL_CHANCE = 0.03f;
    boolean searchingForLand;
    protected final WaterBoundPathNavigation waterNavigation;
    protected final GroundPathNavigation groundNavigation;

    public Drowned_Host_Entity(EntityType<? extends Drowned_Host_Entity> entityType, Level level) {
        super(entityType, level);
        this.f_21342_ = new DrownedMoveControl(this);
        this.m_274367_(1.0f);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.waterNavigation = new WaterBoundPathNavigation((Mob)this, level);
        this.groundNavigation = new GroundPathNavigation((Mob)this, level);
    }

    public static AttributeSupplier.Builder m_34328_() {
        return Monster.m_33035_().m_22268_(Attributes.f_22277_, 20.0).m_22268_(Attributes.f_22279_, (double)0.23f).m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22284_, 2.0).m_22266_(Attributes.f_22287_);
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    protected void m_6878_() {
        this.f_21345_.m_25352_(1, (Goal)new DrownedGoToWaterGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new DrownedTridentAttackGoal(this, 1.0, 40, 10.0f));
        this.f_21345_.m_25352_(2, (Goal)new ZombieAttackGoal((Zombie)this, 1.0, false));
        this.f_21345_.m_25352_(5, (Goal)new DrownedGoToBeachGoal(this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new DrownedSwimUpGoal(this, 1.0, this.m_9236_().m_5736_()));
        this.f_21345_.m_25352_(7, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Drowned_Host_Entity.class}).m_26044_(new Class[]{ZombifiedPiglin.class}));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true, false));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Axolotl.class, true, false));
        this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal((Mob)this, Turtle.class, 10, true, false, Turtle.f_30122_));
    }

    protected void m_8022_() {
        boolean flag = !(this.m_6688_() instanceof Mob) || this.m_6688_() instanceof Symbiocto_Entity;
        boolean flag1 = !(this.m_20202_() instanceof Boat);
        this.f_21345_.m_25360_(Goal.Flag.MOVE, flag);
        this.f_21345_.m_25360_(Goal.Flag.JUMP, flag && flag1);
        this.f_21345_.m_25360_(Goal.Flag.LOOK, flag);
        this.f_21345_.m_25360_(Goal.Flag.TARGET, flag);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor accessor, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData data, @Nullable CompoundTag tag) {
        data = super.m_6518_(accessor, difficulty, reason, data, tag);
        Symbiocto_Entity upper = new Symbiocto_Entity((EntityType)ModEntities.SYMBIOCTO.get(), this.m_9236_());
        upper.m_7678_(this.m_20185_(), this.m_20186_() + 1.3125, this.m_20189_(), this.m_146908_(), 0.0f);
        upper.m_6518_(accessor, difficulty, MobSpawnType.NATURAL, data, tag);
        upper.m_5618_(this.f_20883_);
        upper.m_5616_(this.m_6080_());
        upper.m_146922_(this.m_146908_());
        upper.m_20329_((Entity)this);
        return data;
    }

    public static boolean checkDrownedSpawnRules(EntityType<Drowned_Host_Entity> p_218956_, ServerLevelAccessor p_218957_, MobSpawnType p_218958_, BlockPos p_218959_, RandomSource p_218960_) {
        boolean flag;
        if (!p_218957_.m_6425_(p_218959_.m_7495_()).m_205070_(FluidTags.f_13131_)) {
            return false;
        }
        Holder holder = p_218957_.m_204166_(p_218959_);
        boolean bl = flag = p_218957_.m_46791_() != Difficulty.PEACEFUL && Drowned_Host_Entity.m_219009_((ServerLevelAccessor)p_218957_, (BlockPos)p_218959_, (RandomSource)p_218960_) && (p_218958_ == MobSpawnType.SPAWNER || p_218957_.m_6425_(p_218959_).m_205070_(FluidTags.f_13131_));
        if (holder.m_203656_(BiomeTags.f_215814_)) {
            return p_218960_.m_188503_(15) == 0 && flag;
        }
        return p_218960_.m_188503_(40) == 0 && Drowned_Host_Entity.isDeepEnoughToSpawn((LevelAccessor)p_218957_, p_218959_) && flag;
    }

    public void m_19956_(Entity entity, Entity.MoveFunction callback) {
        super.m_19956_(entity, callback);
        if (entity instanceof Symbiocto_Entity) {
            Symbiocto_Entity goblin = (Symbiocto_Entity)entity;
            goblin.m_5618_(this.f_20883_);
            goblin.m_5616_(this.m_6080_());
            goblin.m_146922_(this.m_146908_());
        }
    }

    private static boolean isDeepEnoughToSpawn(LevelAccessor level, BlockPos pos) {
        return pos.m_123342_() < level.m_5736_() - 5;
    }

    protected boolean m_7586_() {
        return false;
    }

    public boolean m_6162_() {
        return false;
    }

    public boolean m_7307_(Entity entityIn) {
        if (entityIn == this) {
            return true;
        }
        if (super.m_7307_(entityIn)) {
            return true;
        }
        if (entityIn.m_6095_().m_204039_(ModTag.TEAM_SCYLLA)) {
            return this.m_5647_() == null && entityIn.m_5647_() == null;
        }
        return false;
    }

    protected SoundEvent m_7515_() {
        return this.m_20069_() ? SoundEvents.f_11816_ : SoundEvents.f_11815_;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return this.m_20069_() ? SoundEvents.f_11820_ : SoundEvents.f_11819_;
    }

    protected SoundEvent m_5592_() {
        return this.m_20069_() ? SoundEvents.f_11818_ : SoundEvents.f_11817_;
    }

    protected SoundEvent m_7660_() {
        return SoundEvents.f_11875_;
    }

    protected SoundEvent m_5501_() {
        return SoundEvents.f_11876_;
    }

    protected ItemStack m_5728_() {
        return ItemStack.f_41583_;
    }

    protected void m_213945_(RandomSource random, DifficultyInstance difficulty) {
        if ((double)random.m_188501_() > 0.9) {
            int i = random.m_188503_(16);
            if (i < 10) {
                this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42713_));
            } else {
                this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42523_));
            }
        }
    }

    protected boolean m_7808_(ItemStack candidate, ItemStack existing) {
        if (existing.m_150930_(Items.f_42715_)) {
            return false;
        }
        if (existing.m_150930_(Items.f_42713_)) {
            return candidate.m_150930_(Items.f_42713_) ? candidate.m_41773_() < existing.m_41773_() : false;
        }
        return candidate.m_150930_(Items.f_42713_) ? true : super.m_7808_(candidate, existing);
    }

    protected boolean m_7593_() {
        return false;
    }

    protected boolean m_5884_() {
        return !this.m_20160_() || !(this.m_20197_().get(0) instanceof Symbiocto_Entity);
    }

    public boolean m_6914_(LevelReader level) {
        return level.m_45784_((Entity)this);
    }

    public boolean m_6063_() {
        return !this.m_6069_();
    }

    boolean wantsToSwim() {
        if (this.searchingForLand) {
            return true;
        }
        LivingEntity livingentity = this.m_5448_();
        return livingentity != null && livingentity.m_20069_();
    }

    public void m_7023_(Vec3 travelVector) {
        if (this.m_6109_() && this.m_20069_() && this.wantsToSwim()) {
            this.m_19920_(0.01f, travelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
        } else {
            super.m_7023_(travelVector);
        }
    }

    public void m_5844_() {
        if (!this.m_9236_().f_46443_) {
            if (this.m_21515_() && this.m_20069_() && this.wantsToSwim()) {
                this.f_21344_ = this.waterNavigation;
                this.m_20282_(true);
            } else {
                this.f_21344_ = this.groundNavigation;
                this.m_20282_(false);
            }
        }
    }

    public boolean m_6067_() {
        return this.m_6069_();
    }

    protected boolean closeToNextPos() {
        double d0;
        BlockPos blockpos;
        Path path = this.m_21573_().m_26570_();
        return path != null && (blockpos = path.m_77406_()) != null && (d0 = this.m_20275_(blockpos.m_123341_(), blockpos.m_123342_(), blockpos.m_123343_())) < 4.0;
    }

    public void m_6504_(LivingEntity target, float distanceFactor) {
        ThrownTrident throwntrident = new ThrownTrident(this.m_9236_(), (LivingEntity)this, new ItemStack((ItemLike)Items.f_42713_));
        double d0 = target.m_20185_() - this.m_20185_();
        double d1 = target.m_20227_(0.3333333333333333) - throwntrident.m_20186_();
        double d2 = target.m_20189_() - this.m_20189_();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        throwntrident.m_6686_(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.m_9236_().m_46791_().m_19028_() * 4));
        this.m_5496_(SoundEvents.f_11821_, 1.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
        this.m_9236_().m_7967_((Entity)throwntrident);
    }

    public void setSearchingForLand(boolean searchingForLand) {
        this.searchingForLand = searchingForLand;
    }

    static class DrownedMoveControl
    extends MoveControl {
        private final Drowned_Host_Entity drowned;

        public DrownedMoveControl(Drowned_Host_Entity drowned) {
            super((Mob)drowned);
            this.drowned = drowned;
        }

        public void m_8126_() {
            LivingEntity livingentity = this.drowned.m_5448_();
            if (this.drowned.wantsToSwim() && this.drowned.m_20069_()) {
                if (livingentity != null && livingentity.m_20186_() > this.drowned.m_20186_() || this.drowned.searchingForLand) {
                    this.drowned.m_20256_(this.drowned.m_20184_().m_82520_(0.0, 0.002, 0.0));
                }
                if (this.f_24981_ != MoveControl.Operation.MOVE_TO || this.drowned.m_21573_().m_26571_()) {
                    this.drowned.m_7910_(0.0f);
                    return;
                }
                double d0 = this.f_24975_ - this.drowned.m_20185_();
                double d1 = this.f_24976_ - this.drowned.m_20186_();
                double d2 = this.f_24977_ - this.drowned.m_20189_();
                double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                d1 /= d3;
                float f = (float)(Mth.m_14136_((double)d2, (double)d0) * 180.0 / 3.1415927410125732) - 90.0f;
                this.drowned.m_146922_(this.m_24991_(this.drowned.m_146908_(), f, 90.0f));
                this.drowned.f_20883_ = this.drowned.m_146908_();
                float f1 = (float)(this.f_24978_ * this.drowned.m_21133_(Attributes.f_22279_));
                float f2 = Mth.m_14179_((float)0.125f, (float)this.drowned.m_6113_(), (float)f1);
                this.drowned.m_7910_(f2);
                this.drowned.m_20256_(this.drowned.m_20184_().m_82520_((double)f2 * d0 * 0.005, (double)f2 * d1 * 0.1, (double)f2 * d2 * 0.005));
            } else {
                if (!this.drowned.m_20096_()) {
                    this.drowned.m_20256_(this.drowned.m_20184_().m_82520_(0.0, -0.008, 0.0));
                }
                super.m_8126_();
            }
        }
    }

    static class DrownedGoToWaterGoal
    extends Goal {
        private final PathfinderMob mob;
        private double wantedX;
        private double wantedY;
        private double wantedZ;
        private final double speedModifier;
        private final Level level;

        public DrownedGoToWaterGoal(PathfinderMob mob, double speedModifier) {
            this.mob = mob;
            this.speedModifier = speedModifier;
            this.level = mob.m_9236_();
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (!this.level.m_46461_()) {
                return false;
            }
            if (this.mob.m_20069_()) {
                return false;
            }
            Vec3 vec3 = this.getWaterPos();
            if (vec3 == null) {
                return false;
            }
            this.wantedX = vec3.f_82479_;
            this.wantedY = vec3.f_82480_;
            this.wantedZ = vec3.f_82481_;
            return true;
        }

        public boolean m_8045_() {
            return !this.mob.m_21573_().m_26571_();
        }

        public void m_8056_() {
            this.mob.m_21573_().m_26519_(this.wantedX, this.wantedY, this.wantedZ, this.speedModifier);
        }

        @javax.annotation.Nullable
        private Vec3 getWaterPos() {
            RandomSource randomsource = this.mob.m_217043_();
            BlockPos blockpos = this.mob.m_20183_();
            for (int i = 0; i < 10; ++i) {
                BlockPos blockpos1 = blockpos.m_7918_(randomsource.m_188503_(20) - 10, 2 - randomsource.m_188503_(8), randomsource.m_188503_(20) - 10);
                if (!this.level.m_8055_(blockpos1).m_60713_(Blocks.f_49990_)) continue;
                return Vec3.m_82539_((Vec3i)blockpos1);
            }
            return null;
        }
    }

    static class DrownedTridentAttackGoal
    extends RangedAttackGoal {
        private final Drowned_Host_Entity drowned;

        public DrownedTridentAttackGoal(RangedAttackMob rangedAttackMob, double speedModifier, int attackInterval, float attackRadius) {
            super(rangedAttackMob, speedModifier, attackInterval, attackRadius);
            this.drowned = (Drowned_Host_Entity)rangedAttackMob;
        }

        public boolean m_8036_() {
            return super.m_8036_() && this.drowned.m_21205_().m_150930_(Items.f_42713_);
        }

        public void m_8056_() {
            super.m_8056_();
            this.drowned.m_21561_(true);
            this.drowned.m_6672_(InteractionHand.MAIN_HAND);
        }

        public void m_8041_() {
            super.m_8041_();
            this.drowned.m_5810_();
            this.drowned.m_21561_(false);
        }
    }

    static class DrownedGoToBeachGoal
    extends MoveToBlockGoal {
        private final Drowned_Host_Entity drowned;

        public DrownedGoToBeachGoal(Drowned_Host_Entity drowned, double speedModifier) {
            super((PathfinderMob)drowned, speedModifier, 8, 2);
            this.drowned = drowned;
        }

        public boolean m_8036_() {
            return super.m_8036_() && !this.drowned.m_9236_().m_46461_() && this.drowned.m_20069_() && this.drowned.m_20186_() >= (double)(this.drowned.m_9236_().m_5736_() - 3);
        }

        public boolean m_8045_() {
            return super.m_8045_();
        }

        protected boolean m_6465_(LevelReader level, BlockPos pos) {
            BlockPos blockpos = pos.m_7494_();
            return level.m_46859_(blockpos) && level.m_46859_(blockpos.m_7494_()) ? level.m_8055_(pos).m_60634_((BlockGetter)level, pos, (Entity)this.drowned) : false;
        }

        public void m_8056_() {
            this.drowned.setSearchingForLand(false);
            this.drowned.f_21344_ = this.drowned.groundNavigation;
            super.m_8056_();
        }

        public void m_8041_() {
            super.m_8041_();
        }
    }

    static class DrownedSwimUpGoal
    extends Goal {
        private final Drowned_Host_Entity drowned;
        private final double speedModifier;
        private final int seaLevel;
        private boolean stuck;

        public DrownedSwimUpGoal(Drowned_Host_Entity drowned, double speedModifier, int seaLevel) {
            this.drowned = drowned;
            this.speedModifier = speedModifier;
            this.seaLevel = seaLevel;
        }

        public boolean m_8036_() {
            return !this.drowned.m_9236_().m_46461_() && this.drowned.m_20069_() && this.drowned.m_20186_() < (double)(this.seaLevel - 2);
        }

        public boolean m_8045_() {
            return this.m_8036_() && !this.stuck;
        }

        public void m_8037_() {
            if (this.drowned.m_20186_() < (double)(this.seaLevel - 1) && (this.drowned.m_21573_().m_26571_() || this.drowned.closeToNextPos())) {
                Vec3 vec3 = DefaultRandomPos.m_148412_((PathfinderMob)this.drowned, (int)4, (int)8, (Vec3)new Vec3(this.drowned.m_20185_(), (double)(this.seaLevel - 1), this.drowned.m_20189_()), (double)1.5707963705062866);
                if (vec3 == null) {
                    this.stuck = true;
                    return;
                }
                this.drowned.m_21573_().m_26519_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, this.speedModifier);
            }
        }

        public void m_8056_() {
            this.drowned.setSearchingForLand(true);
            this.stuck = false;
        }

        public void m_8041_() {
            this.drowned.setSearchingForLand(false);
        }
    }
}

