/*
 * Decompiled with CFR 0.152.
 */
package com.github.L_Ender.cataclysm.client.particle;

import com.github.L_Ender.cataclysm.client.render.etc.LightningBoltData;
import com.github.L_Ender.cataclysm.client.render.etc.LightningRender;
import com.github.L_Ender.cataclysm.init.ModParticle;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import java.util.Random;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Vector4f;

public class SparkTrailParticle
extends Particle {
    private double toX;
    private double toY;
    private double toZ;
    private LightningRender lightningRender = new LightningRender();

    public SparkTrailParticle(ClientLevel world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, int r, int g, int b) {
        super(world, x, y, z);
        this.m_107250_(1.0f, 1.0f);
        this.f_107226_ = 0.0f;
        this.f_107225_ = 5 + new Random().nextInt(3);
        this.toX = xSpeed;
        this.toY = ySpeed;
        this.toZ = zSpeed;
        this.f_107227_ = r;
        this.f_107228_ = g;
        this.f_107229_ = b;
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107433_;
    }

    public void m_5744_(VertexConsumer vertexConsumer, Camera camera, float partialTick) {
        Vec3 vec3 = camera.m_90583_();
        PoseStack posestack = new PoseStack();
        MultiBufferSource.BufferSource multibuffersource$buffersource = Minecraft.m_91087_().m_91269_().m_110104_();
        float f = (float)(Mth.m_14139_((double)partialTick, (double)this.f_107209_, (double)this.f_107212_) - vec3.m_7096_());
        float f1 = (float)(Mth.m_14139_((double)partialTick, (double)this.f_107210_, (double)this.f_107213_) - vec3.m_7098_());
        float f2 = (float)(Mth.m_14139_((double)partialTick, (double)this.f_107211_, (double)this.f_107214_) - vec3.m_7094_());
        float scale = 1.85f;
        posestack.m_85836_();
        posestack.m_252880_(f, f1, f2);
        posestack.m_85841_(scale, scale, scale);
        LightningBoltData.BoltRenderInfo lightningBoltData = new LightningBoltData.BoltRenderInfo(0.5f, 0.1f, 0.5f, 0.85f, new Vector4f(this.f_107227_ / 255.0f, this.f_107228_ / 255.0f, this.f_107229_ / 255.0f, 1.0f), 0.9f);
        LightningBoltData bolt = new LightningBoltData(lightningBoltData, Vec3.f_82478_, new Vec3(this.toX, this.toY, this.toZ), 2).size(0.05f).lifespan(this.f_107225_).spawn(LightningBoltData.SpawnFunction.CONSECUTIVE);
        this.lightningRender.update((Object)this, bolt, partialTick);
        this.lightningRender.render(partialTick, posestack, (MultiBufferSource)multibuffersource$buffersource);
        multibuffersource$buffersource.m_109911_();
        posestack.m_85849_();
    }

    public static class SparkData
    implements ParticleOptions {
        public static final ParticleOptions.Deserializer<SparkData> DESERIALIZER = new ParticleOptions.Deserializer<SparkData>(){

            public SparkData fromCommand(ParticleType<SparkData> particleTypeIn, StringReader reader) throws CommandSyntaxException {
                reader.expect(' ');
                int r = reader.readInt();
                reader.expect(' ');
                int g = reader.readInt();
                reader.expect(' ');
                int b = reader.readInt();
                return new SparkData(r, g, b);
            }

            public SparkData fromNetwork(ParticleType<SparkData> particleTypeIn, FriendlyByteBuf buffer) {
                return new SparkData(buffer.readInt(), buffer.readInt(), buffer.readInt());
            }
        };
        private final int r;
        private final int g;
        private final int b;

        public SparkData(int r, int g, int b) {
            this.r = r;
            this.g = g;
            this.b = b;
        }

        public void m_7711_(FriendlyByteBuf buffer) {
            buffer.writeInt(this.r);
            buffer.writeInt(this.g);
            buffer.writeInt(this.b);
        }

        public String m_5942_() {
            return String.format(Locale.ROOT, "%s %d %d %d", BuiltInRegistries.f_257034_.m_7981_(this.m_6012_()), this.r, this.g, this.b);
        }

        public ParticleType<SparkData> m_6012_() {
            return (ParticleType)ModParticle.SPARK_TRAIL.get();
        }

        @OnlyIn(value=Dist.CLIENT)
        public int getR() {
            return this.r;
        }

        @OnlyIn(value=Dist.CLIENT)
        public int getG() {
            return this.g;
        }

        @OnlyIn(value=Dist.CLIENT)
        public int getB() {
            return this.b;
        }

        public static Codec<SparkData> CODEC(ParticleType<SparkData> particleType) {
            return RecordCodecBuilder.create(codecBuilder -> codecBuilder.group((App)Codec.INT.fieldOf("r").forGetter(SparkData::getR), (App)Codec.INT.fieldOf("g").forGetter(SparkData::getG), (App)Codec.INT.fieldOf("b").forGetter(SparkData::getB)).apply((Applicative)codecBuilder, SparkData::new));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<SparkData> {
        public Particle createParticle(SparkData data, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            SparkTrailParticle particle = new SparkTrailParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, data.getR(), data.getG(), data.getB());
            return particle;
        }
    }
}

