/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.immediatelyfast.injection.mixins.core.compat;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.font.FontSet;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.raphimc.immediatelyfast.ImmediatelyFast;
import net.raphimc.immediatelyfast.compat.CoreShaderBlacklist;
import net.raphimc.immediatelyfast.feature.core.ImmediatelyFastResourcePackMetadata;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GameRenderer.class})
public abstract class MixinGameRenderer {
    @Shadow
    @Final
    private Map<String, ShaderInstance> f_172578_;

    @Inject(method={"m_172767_(Lnet/minecraft/server/packs/resources/ResourceProvider;)V"}, at={@At(value="RETURN")})
    private void checkForCoreShaderModifications(ResourceProvider factory, CallbackInfo ci) {
        if (ImmediatelyFast.config.experimental_disable_resource_pack_conflict_handling) {
            return;
        }
        PackResources resourcePackWhichBreaksFontAtlasResizing = null;
        PackResources resourcePackWhichBreaksHudBatching = null;
        try {
            HashSet<PackResources> breakingResourcePacks = new HashSet<PackResources>();
            for (Map.Entry<String, ShaderInstance> shaderProgramEntry : this.f_172578_.entrySet()) {
                ResourceLocation fragmentShaderIdentifier;
                PackResources fragmentShaderResourcePack;
                if (!CoreShaderBlacklist.isBlacklisted(shaderProgramEntry.getKey())) continue;
                ResourceLocation vertexShaderIdentifier = new ResourceLocation("shaders/core/" + shaderProgramEntry.getValue().m_108962_().m_85551_() + ".vsh");
                PackResources vertexShaderResourcePack = factory.m_213713_(vertexShaderIdentifier).map(Resource::m_247173_).orElse(null);
                if (vertexShaderResourcePack != null && !vertexShaderResourcePack.equals(Minecraft.m_91087_().m_246804_())) {
                    breakingResourcePacks.add(vertexShaderResourcePack);
                }
                if ((fragmentShaderResourcePack = (PackResources)factory.m_213713_(fragmentShaderIdentifier = new ResourceLocation("shaders/core/" + shaderProgramEntry.getValue().m_108964_().m_85551_() + ".fsh")).map(Resource::m_247173_).orElse(null)) == null || fragmentShaderResourcePack.equals(Minecraft.m_91087_().m_246804_())) continue;
                breakingResourcePacks.add(fragmentShaderResourcePack);
            }
            for (PackResources resourcePack : breakingResourcePacks) {
                ImmediatelyFastResourcePackMetadata metadata = (ImmediatelyFastResourcePackMetadata)resourcePack.m_5550_(ImmediatelyFastResourcePackMetadata.SERIALIZER);
                if (metadata == null) {
                    metadata = ImmediatelyFastResourcePackMetadata.DEFAULT;
                }
                if (!metadata.compatibleFeatures().contains("font_atlas_resizing")) {
                    resourcePackWhichBreaksFontAtlasResizing = resourcePack;
                }
                if (metadata.compatibleFeatures().contains("hud_batching")) continue;
                resourcePackWhichBreaksHudBatching = resourcePack;
            }
        }
        catch (IOException e) {
            ImmediatelyFast.LOGGER.error("Failed to check for core shader modifications", (Throwable)e);
        }
        if (ImmediatelyFast.runtimeConfig.font_atlas_resizing && resourcePackWhichBreaksFontAtlasResizing != null) {
            ImmediatelyFast.LOGGER.warn("Resource pack " + resourcePackWhichBreaksFontAtlasResizing.m_5542_() + " is not compatible with font atlas resizing. Temporarily disabling font atlas resizing.");
            ImmediatelyFast.runtimeConfig.font_atlas_resizing = false;
            this.immediatelyFast$reloadFontStorages();
        } else if (!ImmediatelyFast.runtimeConfig.font_atlas_resizing && ImmediatelyFast.config.font_atlas_resizing) {
            ImmediatelyFast.runtimeConfig.font_atlas_resizing = true;
            this.immediatelyFast$reloadFontStorages();
        }
        if (ImmediatelyFast.runtimeConfig.hud_batching && resourcePackWhichBreaksHudBatching != null) {
            ImmediatelyFast.LOGGER.warn("Resource pack " + resourcePackWhichBreaksHudBatching.m_5542_() + " is not compatible with HUD batching. Temporarily disabling HUD batching.");
            ImmediatelyFast.runtimeConfig.hud_batching = false;
        } else {
            ImmediatelyFast.runtimeConfig.hud_batching = ImmediatelyFast.config.hud_batching;
        }
    }

    @Unique
    private void immediatelyFast$reloadFontStorages() {
        for (FontSet storage : Minecraft.m_91087_().f_91045_.f_94999_.values()) {
            ArrayList fonts = new ArrayList(storage.f_95055_);
            storage.f_95055_.clear();
            storage.m_95071_(fonts);
        }
    }
}

