/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.util.configured.types;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.IntPredicate;
import java.util.stream.Collectors;
import org.zeith.hammerlib.util.configured.ConfigToken;
import org.zeith.hammerlib.util.configured.io.IoNewLiner;
import org.zeith.hammerlib.util.configured.io.StringReader;
import org.zeith.hammerlib.util.configured.io.buf.IByteBuf;

public abstract class ConfigElement<T extends ConfigElement<T>> {
    protected final ConfigToken<T> token;
    protected Runnable onChanged;
    protected String name;
    protected String comment;
    protected IntPredicate nameTerminator = c -> false;

    public ConfigElement(Runnable onChanged, ConfigToken<T> token, String name) {
        this.onChanged = onChanged;
        this.token = token;
        this.name = name;
        if (onChanged != null) {
            onChanged.run();
        }
    }

    public abstract Object getValue();

    public String getName() {
        return this.name;
    }

    public final ConfigToken<T> getToken() {
        return this.token;
    }

    public String getComment() {
        return this.comment;
    }

    public String getEscapedComment() {
        String comment = this.getComment();
        return comment != null ? comment.replace("\n", "\\n") : "";
    }

    public T withComment(String comment) {
        if (!Objects.equals(this.comment, comment) && this.onChanged != null) {
            this.onChanged.run();
        }
        this.comment = comment;
        return (T)this;
    }

    protected Optional<String> readComment(BufferedReader reader, int depth) throws IOException {
        int r;
        if (StringReader.skipWhitespaces(reader) != 47 || reader.read() != 42) {
            reader.reset();
            return Optional.empty();
        }
        StringBuilder sb = new StringBuilder();
        boolean closed = false;
        boolean backspace = false;
        while ((r = reader.read()) >= 0) {
            if (r == 92) {
                if (!backspace) {
                    backspace = true;
                    continue;
                }
                sb.append((char)r);
                backspace = false;
                continue;
            }
            if (r == 42 && backspace) {
                sb.append((char)r);
                continue;
            }
            if (r == 47 && sb.charAt(sb.length() - 1) == '*' && !backspace) {
                sb.deleteCharAt(sb.length() - 1);
                closed = true;
                break;
            }
            sb.append((char)r);
            backspace = false;
        }
        String str = sb.toString().replace(System.lineSeparator(), "\n").lines().map(String::trim).filter(s -> !s.isBlank()).collect(Collectors.joining("\n"));
        while (str.startsWith("\n")) {
            str = str.substring(1);
        }
        while (str.endsWith("\n")) {
            str = str.substring(0, str.length() - 1);
        }
        return !closed ? Optional.empty() : Optional.of(str.stripIndent());
    }

    public abstract boolean read(BufferedReader var1, int var2, String var3) throws IOException;

    public abstract void write(BufferedWriter var1, IoNewLiner var2) throws IOException;

    public abstract void toBuffer(IByteBuf var1);

    public abstract void fromBuffer(IByteBuf var1);
}

