/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.util.configured.struct;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.zeith.hammerlib.util.configured.ConfiguredLib;
import org.zeith.hammerlib.util.configured.struct.Comment;
import org.zeith.hammerlib.util.configured.struct.Name;
import org.zeith.hammerlib.util.configured.struct.SetDefaults;
import org.zeith.hammerlib.util.configured.struct.Unconfigurable;
import org.zeith.hammerlib.util.configured.struct.mappers.DecimalMapper;
import org.zeith.hammerlib.util.configured.struct.mappers.ITokenMapper;
import org.zeith.hammerlib.util.configured.struct.mappers.IntegerMapper;
import org.zeith.hammerlib.util.configured.struct.mappers.StringMapper;
import org.zeith.hammerlib.util.configured.struct.reflection.IField;
import org.zeith.hammerlib.util.configured.types.ConfigCategory;
import org.zeith.hammerlib.util.configured.types.ConfigElement;
import org.zeith.hammerlib.util.configured.types.ConfigObject;
import org.zeith.hammerlib.util.java.tuples.Tuple3;
import org.zeith.hammerlib.util.java.tuples.Tuples;

public class ConfigStructure {
    private static final Map<Class<?>, ITokenMapper<?, ?>> TOKENS_BY_TYPE = new HashMap();

    public static synchronized void registerTokenWriter(ITokenMapper<?, ?> writer) {
        TOKENS_BY_TYPE.put(writer.getType(), writer);
    }

    public static <A extends ConfigElement<A>, T> ITokenMapper<A, T> getToken(Class<T> type) {
        if (type.isArray()) {
            ITokenMapper<A, ?> sub = ConfigStructure.getToken(type.getComponentType());
            return sub == null ? null : sub.arrayOf();
        }
        return TOKENS_BY_TYPE.get(type);
    }

    public static <T> T createConfig(Supplier<T> newInstance, ConfigObject<?> obj, boolean setDefault) {
        return ConfigStructure.apply(newInstance.get(), obj, setDefault);
    }

    public static <T> T apply(T instance, ConfigObject<?> obj, boolean setDefault) {
        for (Method method : instance.getClass().getMethods()) {
            if (!method.isAnnotationPresent(SetDefaults.class) || method.getParameterCount() != 0) continue;
            try {
                method.setAccessible(true);
                method.invoke(instance, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        for (AccessibleObject accessibleObject : instance.getClass().getFields()) {
            if (accessibleObject.isAnnotationPresent(Unconfigurable.class)) continue;
            Name nameAnn = ((Field)accessibleObject).getAnnotation(Name.class);
            String name = nameAnn != null ? nameAnn.value() : ((Field)accessibleObject).getName();
            ConfigStructure.loadField(IField.wrap((Field)accessibleObject, instance), name, obj, setDefault);
        }
        return instance;
    }

    private static <T> void loadField(IField<T> field, String name, ConfigObject<?> obj, boolean setDefault) {
        Tuple3.Mutable3 tup = ConfigStructure.obtain(field, name, obj);
        if (tup == null) {
            T b = field.get();
            if (Modifier.isFinal(field.getModifiers()) && b != null) {
                ConfigCategory sub = obj.getElement(ConfiguredLib.CATEGORY, name);
                field.annotation(Comment.class).map(Comment::value).ifPresent(sub::withComment);
                ConfigStructure.apply(b, sub, setDefault);
            }
            return;
        }
        field.annotation(Comment.class).map(Comment::value).ifPresent(((ConfigElement)tup.a())::withComment);
        if (setDefault) {
            ((ITokenMapper)tup.c()).defaultValue((ConfigElement)tup.a(), field, field.get());
        }
        field.set(ConfigStructure.obtain(field, name, obj).b());
    }

    private static <A extends ConfigElement<A>, T> Tuple3.Mutable3<A, T, ITokenMapper<A, T>> obtain(IField<T> field, String name, ConfigObject<?> obj) {
        ITokenMapper<A, A> mapper = ConfigStructure.getToken(field.getType());
        if (mapper == null) {
            return null;
        }
        A a = obj.getElement(mapper.getToken(), name);
        return Tuples.mutable(a, mapper.apply(a), mapper);
    }

    static {
        ConfigStructure.registerTokenWriter(new IntegerMapper<Byte>(Byte.TYPE, Number::byteValue));
        ConfigStructure.registerTokenWriter(new IntegerMapper<Byte>(Byte.class, Number::byteValue));
        ConfigStructure.registerTokenWriter(new IntegerMapper<Short>(Short.TYPE, Number::shortValue));
        ConfigStructure.registerTokenWriter(new IntegerMapper<Short>(Short.class, Number::shortValue));
        ConfigStructure.registerTokenWriter(new IntegerMapper<Long>(Long.TYPE, BigInteger::longValue));
        ConfigStructure.registerTokenWriter(new IntegerMapper<Long>(Long.class, BigInteger::longValue));
        ConfigStructure.registerTokenWriter(new IntegerMapper<Integer>(Integer.TYPE, BigInteger::intValue));
        ConfigStructure.registerTokenWriter(new IntegerMapper<Integer>(Integer.class, BigInteger::intValue));
        ConfigStructure.registerTokenWriter(new IntegerMapper<BigInteger>(BigInteger.class, UnaryOperator.identity()));
        ConfigStructure.registerTokenWriter(new DecimalMapper<Float>(Float.TYPE, BigDecimal::floatValue));
        ConfigStructure.registerTokenWriter(new DecimalMapper<Float>(Float.class, BigDecimal::floatValue));
        ConfigStructure.registerTokenWriter(new DecimalMapper<Double>(Double.TYPE, BigDecimal::doubleValue));
        ConfigStructure.registerTokenWriter(new DecimalMapper<Double>(Double.class, BigDecimal::doubleValue));
        ConfigStructure.registerTokenWriter(new DecimalMapper<BigDecimal>(BigDecimal.class, UnaryOperator.identity()));
        ConfigStructure.registerTokenWriter(new StringMapper());
    }
}

