/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.util.charging.impl;

import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.zeith.hammerlib.util.charging.IChargeHandler;
import org.zeith.hammerlib.util.charging.fluid.FluidCharge;

@IChargeHandler.ChargeHandler(value=FluidCharge.class)
public class FluidChargeHandler
implements IChargeHandler<FluidCharge> {
    @Override
    public String getId() {
        return "Fluid";
    }

    @Override
    public boolean canCharge(ItemStack stack, FluidCharge charge) {
        return stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM, null).map(cap -> cap.fill(charge.fluid.copy(), IFluidHandler.FluidAction.SIMULATE) > 0).orElse(false);
    }

    @Override
    public FluidCharge charge(AtomicReference<ItemStack> stack, FluidCharge charge, IChargeHandler.ChargeAction action) {
        return stack.get().getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM, null).map(cap -> {
            FluidCharge c = charge.discharge(cap.fill(charge.fluid.copy(), action.asFluidAction()));
            stack.set(cap.getContainer());
            return c;
        }).orElse(charge);
    }
}

