/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.core.adapter;

import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.StringUtil;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLModContainer;
import net.minecraftforge.fml.loading.FMLPaths;
import org.zeith.hammerlib.HammerLib;
import org.zeith.hammerlib.annotations.OnlyIf;
import org.zeith.hammerlib.annotations.SetupConfigs;
import org.zeith.hammerlib.api.config.Config;
import org.zeith.hammerlib.api.config.ConfigException;
import org.zeith.hammerlib.api.config.IConfigRoot;
import org.zeith.hammerlib.core.adapter.OnlyIfAdapter;
import org.zeith.hammerlib.core.scans.base.IAnnotationScanListener;
import org.zeith.hammerlib.core.scans.base.IScanListener;
import org.zeith.hammerlib.event.player.PlayerLoadedInEvent;
import org.zeith.hammerlib.net.lft.NetTransport;
import org.zeith.hammerlib.net.packets.PacketSyncConfigs;
import org.zeith.hammerlib.util.SidedLocal;
import org.zeith.hammerlib.util.configured.ConfigFile;
import org.zeith.hammerlib.util.java.Cast;
import org.zeith.hammerlib.util.mcf.ScanDataHelper;

@Mod.EventBusSubscriber
public class ConfigAdapter {
    private static final Map<String, ConfigFile> FILE_HASH = new HashMap<String, ConfigFile>();
    private static final Map<Class<? extends IConfigRoot>, CompoundTag> CLIENT_STATE = new HashMap<Class<? extends IConfigRoot>, CompoundTag>();
    private static final SidedLocal<Map<Class<? extends IConfigRoot>, IConfigRoot>> STRUCTURES = new SidedLocal<Map>(side -> new HashMap());

    @SubscribeEvent
    public static void syncConfigs(PlayerLoadedInEvent event) {
        HashMap<Class<? extends IConfigRoot>, IConfigRoot> map = new HashMap<Class<? extends IConfigRoot>, IConfigRoot>(STRUCTURES.get(LogicalSide.SERVER));
        map.values().removeIf(IConfigRoot::avoidSync);
        NetTransport.wrap(new PacketSyncConfigs(map)).sendTo(event.getEntity());
    }

    public static void handleClientsideSync(PacketSyncConfigs packet) {
        Map<Class<? extends IConfigRoot>, IConfigRoot> map = STRUCTURES.get(LogicalSide.CLIENT);
        CLIENT_STATE.clear();
        packet.data().forEach((type, tag) -> {
            IConfigRoot configRoot = (IConfigRoot)map.get(type);
            if (configRoot != null) {
                CompoundTag sub = new CompoundTag();
                configRoot.toNetwork(sub);
                CLIENT_STATE.put((Class<? extends IConfigRoot>)type, sub);
                configRoot.fromNetwork((CompoundTag)tag);
                configRoot.updateInstance(LogicalSide.CLIENT);
            }
        });
        HammerLib.LOG.info("Applied " + CLIENT_STATE.size() + " configs from server.");
    }

    public static void resetClientsideSync() {
        Map<Class<? extends IConfigRoot>, IConfigRoot> map = STRUCTURES.get(LogicalSide.CLIENT);
        CLIENT_STATE.forEach((type, tag) -> {
            IConfigRoot configRoot = (IConfigRoot)map.get(type);
            if (configRoot != null) {
                configRoot.fromNetwork((CompoundTag)tag);
                configRoot.updateInstance(LogicalSide.CLIENT);
            }
        });
        HammerLib.LOG.info("Reset " + CLIENT_STATE.size() + " configs to their client-side state.");
        CLIENT_STATE.clear();
    }

    public static IScanListener create() {
        return IAnnotationScanListener.forAnnotation(SetupConfigs.class, ElementType.METHOD, ConfigAdapter::handleCfgSetup).then(IAnnotationScanListener.forAnnotation(Config.class, ElementType.TYPE, ConfigAdapter::handleConfigs));
    }

    private static void handleCfgSetup(ScanDataHelper.ModAwareAnnotationData data) {
        Class<?> registerer = data.getOwnerClass();
        HammerLib.LOG.info("Injecting config setup into {}", registerer);
        data.getOwnerMod().ifPresent(b -> ConfigAdapter.configSetup(b, registerer, data.getMemberName()));
    }

    private static void handleConfigs(ScanDataHelper.ModAwareAnnotationData ad) {
        if (!IConfigRoot.class.isAssignableFrom(ad.getOwnerClass())) {
            return;
        }
        try {
            Config cfg = ad.getOwnerClass().getDeclaredAnnotation(Config.class);
            IConfigRoot inst = ad.getOwnerClass().asSubclass(IConfigRoot.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            String module = cfg.module();
            ad.getOwnerMod().ifPresentOrElse(mod -> {
                ConfigAdapter.apply(mod.getModId(), StringUtil.m_14408_((String)module) ? Optional.empty() : Optional.of(module), inst::load);
                inst.updateInstance(LogicalSide.SERVER);
                inst.updateInstance(LogicalSide.CLIENT);
                STRUCTURES.applyForAllSides(map -> {
                    map.put(inst.getClass(), inst);
                    return map;
                });
            }, () -> HammerLib.LOG.warn("Failed to find out the mod for {}. Why though?", ad.getOwnerClass()));
        }
        catch (ReflectiveOperationException e) {
            HammerLib.LOG.error("Failed to create new config instance for {}", ad.getOwnerClass(), (Object)e);
        }
        catch (ConfigException e) {
            HammerLib.LOG.error("Failed to load config file in {} correctly.", ad.getOwnerClass(), (Object)e);
        }
    }

    public static <T extends IConfigRoot> Optional<T> getConfigForSide(LogicalSide side, Class<T> type) {
        return Cast.optionally(STRUCTURES.get(side).get(type), type);
    }

    public static ConfigFile getConfigFile(String mod, Optional<String> module) {
        Path path = module.map(s -> FMLPaths.CONFIGDIR.get().resolve(mod).resolve(s + ".cfg")).orElseGet(() -> FMLPaths.CONFIGDIR.get().resolve(mod + ".cfg"));
        return FILE_HASH.computeIfAbsent(path.toFile().getAbsolutePath(), p -> {
            try {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ConfigFile fl = new ConfigFile(path.toFile());
            fl.load();
            return fl;
        });
    }

    public static void apply(String mod, Optional<String> module, Consumer<ConfigFile> handler) {
        ConfigFile file = ConfigAdapter.getConfigFile(mod, module);
        if (file != null) {
            handler.accept(file);
            if (file.hasChanged()) {
                file.save();
            }
        }
    }

    public static void configSetup(FMLModContainer mod, Class<?> source, String memberName) {
        String methodName = memberName.substring(0, memberName.indexOf(40));
        Arrays.stream(source.getDeclaredMethods()).filter(m -> m.getAnnotation(SetupConfigs.class) != null && m.getName().equals(methodName)).forEach(method -> {
            SetupConfigs cfgs = method.getAnnotation(SetupConfigs.class);
            if (Modifier.isStatic(method.getModifiers())) {
                try {
                    OnlyIf onlyIf = method.getAnnotation(OnlyIf.class);
                    if (!OnlyIfAdapter.checkCondition(onlyIf, source.toString(), "ConfigSetup", null, null)) {
                        return;
                    }
                    method.setAccessible(true);
                    if (method.getParameterCount() == 0) {
                        method.invoke(null, new Object[0]);
                    } else if (method.getParameterCount() == 1 && method.getParameterTypes()[0] == ConfigFile.class) {
                        ConfigFile file = ConfigAdapter.getConfigFile(mod.getModId(), cfgs.module().isEmpty() ? Optional.empty() : Optional.of(cfgs.module()));
                        method.invoke(null, file);
                        if (file.hasChanged()) {
                            file.save();
                        }
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    RuntimeException re = null;
                    if (e instanceof InvocationTargetException && e.getCause() instanceof RuntimeException) {
                        re = (RuntimeException)e.getCause();
                    }
                    if (e instanceof RuntimeException) {
                        re = (RuntimeException)e;
                    }
                    if (re != null) {
                        throw re;
                    }
                    e.printStackTrace();
                }
                catch (Throwable e) {
                    HammerLib.LOG.error("Mod " + mod.getModId() + " has failed to set up it's configs:", e);
                    e.printStackTrace();
                }
            }
        });
    }
}

