/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.core.adapter;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import org.zeith.hammerlib.mixins.BlockEntityTypeAccessor;
import org.zeith.hammerlib.util.java.Cast;

public class BlockEntityAdapter {
    public static Set<Block> getValidBlocks(BlockEntityType<?> type) {
        return ((BlockEntityTypeAccessor)type).getValidBlocks();
    }

    public static synchronized void addBlocksToEntityType(BlockEntityType<?> type, Block ... blocks) {
        BlockEntityTypeAccessor ac = Cast.cast(type, BlockEntityTypeAccessor.class);
        if (ac == null) {
            throw new UnsupportedOperationException("The BlockEntityType mixin accessor failed to apply...");
        }
        Set<Block> valid = ac.getValidBlocks();
        if (!BlockEntityAdapter.tryAdd(valid, blocks)) {
            valid = new HashSet<Block>(valid);
            valid.addAll(List.of(blocks));
            ac.setValidBlocks(valid);
        }
    }

    private static synchronized <T> boolean tryAdd(Collection<T> coll, T ... all) {
        try {
            return coll.addAll(List.of(all));
        }
        catch (UnsupportedOperationException e) {
            return false;
        }
    }
}

