/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.client.flowgui.objects;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Stack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.Rect2i;
import org.zeith.hammerlib.client.flowgui.Graphics;
import org.zeith.hammerlib.client.flowgui.GuiObject;
import org.zeith.hammerlib.client.flowgui.objects.RenderHook;
import org.zeith.hammerlib.client.flowgui.util.GuiObjectHelper;
import org.zeith.hammerlib.client.flowgui.util.ScrollData;
import org.zeith.hammerlib.util.math.Point;

public class GuiRootObject
extends GuiObject
implements GuiEventListener,
Renderable,
NarratableEntry {
    protected boolean focused;
    protected Runnable tickHandler = () -> {};
    public boolean debugBoundaries;
    public int debugBoundaryColor = -39322;

    public GuiRootObject() {
        super("$root");
    }

    public GuiRootObject finishBuilding() {
        Stack<GuiRootObject> traversal = new Stack<GuiRootObject>();
        traversal.push(this);
        while (!traversal.isEmpty()) {
            GuiObject element = (GuiObject)traversal.pop();
            element.finishBuilding.forEach(Runnable::run);
            element.getChildren().forEach(traversal::push);
        }
        return this;
    }

    public GuiRootObject onTick(Runnable task) {
        Runnable prev = this.tickHandler;
        this.tickHandler = () -> {
            prev.run();
            task.run();
        };
        return this;
    }

    @Override
    public GuiRootObject onPreRender(RenderHook task) {
        super.onPreRender(task);
        return this;
    }

    public final GuiRootObject add(GuiObject o) {
        this.addChild(o);
        return this;
    }

    @Override
    protected void update() {
        this.tickHandler.run();
    }

    public PoseStack myPose() {
        return new PoseStack();
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        return this.sendMouseClick(this.myPose(), new Point(mouseX, mouseY), button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        return this.sendMouseDrag(this.myPose(), new Point(mouseX, mouseY), button, new Point(dragX, dragY));
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        return this.sendMouseRelease(this.myPose(), new Point(mouseX, mouseY), button);
    }

    public boolean m_6050_(double pMouseX, double pMouseY, double pScrollY) {
        return this.sendMouseScroll(this.myPose(), new Point(pMouseX, pMouseY), new ScrollData(pScrollY));
    }

    public void m_94757_(double mouseX, double mouseY) {
        this.sendMouseMove(this.myPose(), new Point(mouseX, mouseY));
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        return this.sendKeyPress(pKeyCode, pScanCode, pModifiers);
    }

    public boolean m_7920_(int pKeyCode, int pScanCode, int pModifiers) {
        return this.sendKeyRelease(pKeyCode, pScanCode, pModifiers);
    }

    public boolean m_5534_(char pCodePoint, int pModifiers) {
        return this.sendCharType(pCodePoint, pModifiers);
    }

    public void m_93692_(boolean pFocused) {
        this.focused = pFocused;
    }

    public boolean m_93696_() {
        return this.focused;
    }

    public void m_88315_(GuiGraphics gfx, int mouseX, int mouseY, float partialTick) {
        Minecraft mc = Minecraft.m_91087_();
        float x = (float)(mc.f_91067_.m_91589_() * (double)mc.m_91268_().m_85445_() / (double)mc.m_91268_().m_85443_());
        float y = (float)(mc.f_91067_.m_91594_() * (double)mc.m_91268_().m_85446_() / (double)mc.m_91268_().m_85444_());
        Graphics g = Graphics.builder().gfx(gfx).game(Minecraft.m_91087_()).partialTime(partialTick).debugBounds(this.debugBoundaries).build();
        this.renderObject(g, new Point(x, y));
        this.drawDebugOverlay(g);
    }

    public void drawDebugOverlay(Graphics g) {
        if (g.debugBounds()) {
            int color = this.debugBoundaryColor;
            for (Rect2i rect : GuiObjectHelper.getAllAreas(this)) {
                g.renderOutline(rect.m_110085_(), rect.m_110086_(), rect.m_110090_(), rect.m_110091_(), color);
            }
        }
    }

    public void m_142291_(NarrationElementOutput output) {
    }

    public NarratableEntry.NarrationPriority m_142684_() {
        return NarratableEntry.NarrationPriority.NONE;
    }

    public boolean m_5953_(double pMouseX, double pMouseY) {
        return this.sendMouseClick(this.myPose(), new Point(pMouseX, pMouseY), -25902376);
    }
}

