/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.client.flowgui;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.zeith.hammerlib.client.flowgui.GuiObject;
import org.zeith.hammerlib.client.flowgui.objects.GuiButtonObject;
import org.zeith.hammerlib.client.flowgui.objects.GuiEditBoxObject;
import org.zeith.hammerlib.client.flowgui.objects.GuiImageObject;
import org.zeith.hammerlib.client.flowgui.objects.GuiItemObject;
import org.zeith.hammerlib.client.flowgui.objects.GuiSlotLinkObject;
import org.zeith.hammerlib.client.flowgui.objects.GuiSpriteButtonObject;
import org.zeith.hammerlib.client.flowgui.objects.GuiTextObject;
import org.zeith.hammerlib.client.flowgui.objects.GuiTooltipObject;
import org.zeith.hammerlib.client.flowgui.util.Tooltip;
import org.zeith.hammerlib.util.java.Cast;

public class GuiObjectBuilder {
    private final String name;

    public GuiObjectBuilder(String name) {
        this.name = name;
    }

    public static GuiObjectBuilder named(String name) {
        return new GuiObjectBuilder(name);
    }

    public GuiObject empty() {
        return new GuiObject(this.name);
    }

    public GuiSlotLinkObject slot(Slot slot) {
        return new GuiSlotLinkObject(this.name).bindToSlot(slot);
    }

    public GuiImageObject fullImage(ResourceLocation tex, float width, float height) {
        return this.image(tex, 0.0f, 0.0f, width, height, width, height);
    }

    public GuiImageObject image(ResourceLocation tex, float uOffset, float vOffset, float width, float height, float txWidth, float txHeight) {
        return new GuiImageObject(this.name, Cast.constant(tex), uOffset, vOffset, width, height, txWidth, txHeight);
    }

    public GuiImageObject image(ResourceLocation tex, float uOffset, float vOffset, float width, float height) {
        return this.image(tex, uOffset, vOffset, width, height, 256.0f, 256.0f);
    }

    public GuiImageObject fullImage(Supplier<ResourceLocation> tex, float width, float height) {
        return this.image(tex, 0.0f, 0.0f, width, height, width, height);
    }

    public GuiImageObject image(Supplier<ResourceLocation> tex, float uOffset, float vOffset, float width, float height, float txWidth, float txHeight) {
        return new GuiImageObject(this.name, tex, uOffset, vOffset, width, height, txWidth, txHeight);
    }

    public GuiImageObject image(Supplier<ResourceLocation> tex, float uOffset, float vOffset, float width, float height) {
        return this.image(tex, uOffset, vOffset, width, height, 256.0f, 256.0f);
    }

    public GuiTextObject text(Font font, FormattedCharSequence text, int color, boolean shadow) {
        return new GuiTextObject(this.name, font, text, color, shadow);
    }

    public GuiTextObject text(Component text, int color, boolean shadow) {
        return this.text(Minecraft.m_91087_().f_91062_, text.m_7532_(), color, shadow);
    }

    public GuiTextObject text(Component text) {
        return this.text(text, -1, true);
    }

    public GuiButtonObject.ButtonBuilder button() {
        return GuiButtonObject.builder(this.name);
    }

    public GuiSpriteButtonObject.SpriteButtonBuilder spriteButton() {
        return GuiSpriteButtonObject.of(this.name);
    }

    public GuiEditBoxObject.EditBoxBuilder editBox() {
        return GuiEditBoxObject.builder(this.name);
    }

    public GuiItemObject item(Supplier<ItemStack> stack) {
        return new GuiItemObject(this.name, stack);
    }

    public GuiTooltipObject tooltip(Tooltip tooltip) {
        return new GuiTooltipObject(this.name).tooltip(tooltip);
    }
}

