/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.conduits.common.init;

import com.enderio.EnderIO;
import com.enderio.api.conduit.ConduitItemFactory;
import com.enderio.api.conduit.ConduitType;
import com.enderio.api.filter.ResourceFilter;
import com.enderio.base.common.init.EIOCreativeTabs;
import com.enderio.conduits.common.conduit.upgrade.SpeedUpgradeItem;
import com.enderio.conduits.common.init.ConduitMenus;
import com.enderio.conduits.common.init.EIOConduitTypes;
import com.enderio.conduits.common.items.ConduitProbeItem;
import com.enderio.conduits.common.redstone.RedstoneANDFilter;
import com.enderio.conduits.common.redstone.RedstoneCountFilter;
import com.enderio.conduits.common.redstone.RedstoneFilterItem;
import com.enderio.conduits.common.redstone.RedstoneNANDFilter;
import com.enderio.conduits.common.redstone.RedstoneNORFilter;
import com.enderio.conduits.common.redstone.RedstoneNOTFilter;
import com.enderio.conduits.common.redstone.RedstoneORFilter;
import com.enderio.conduits.common.redstone.RedstoneSensorFilter;
import com.enderio.conduits.common.redstone.RedstoneTLatchFilter;
import com.enderio.conduits.common.redstone.RedstoneTimerFilter;
import com.enderio.conduits.common.redstone.RedstoneXNORFilter;
import com.enderio.conduits.common.redstone.RedstoneXORFilter;
import com.tterrag.registrate.Registrate;
import com.tterrag.registrate.util.entry.ItemEntry;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class ConduitItems {
    private static final Registrate REGISTRATE = EnderIO.registrate();
    public static final ItemEntry<Item> ENERGY = ConduitItems.createConduitItem(EIOConduitTypes.ENERGY, "energy");
    public static final ItemEntry<Item> FLUID = ConduitItems.createConduitItem(EIOConduitTypes.FLUID, "fluid");
    public static final ItemEntry<Item> PRESSURIZED_FLUID = ConduitItems.createConduitItem(EIOConduitTypes.FLUID2, "pressurized_fluid");
    public static final ItemEntry<Item> ENDER_FLUID = ConduitItems.createConduitItem(EIOConduitTypes.FLUID3, "ender_fluid");
    public static final ItemEntry<Item> REDSTONE = ConduitItems.createConduitItem(EIOConduitTypes.REDSTONE, "redstone");
    public static final ItemEntry<Item> ITEM = ConduitItems.createConduitItem(EIOConduitTypes.ITEM, "item");
    public static final ItemEntry<SpeedUpgradeItem> EXTRACTION_SPEED_UPGRADE_1 = REGISTRATE.item("extraction_speed_upgrade_1", props -> new SpeedUpgradeItem((Item.Properties)props, 1)).lang("Tier 1 Extraction Speed Upgrade").tab(EIOCreativeTabs.CONDUITS).register();
    public static final ItemEntry<SpeedUpgradeItem> EXTRACTION_SPEED_UPGRADE_2 = REGISTRATE.item("extraction_speed_upgrade_2", props -> new SpeedUpgradeItem((Item.Properties)props, 2)).lang("Tier 2 Extraction Speed Upgrade").tab(EIOCreativeTabs.CONDUITS).register();
    public static final ItemEntry<SpeedUpgradeItem> EXTRACTION_SPEED_UPGRADE_3 = REGISTRATE.item("extraction_speed_upgrade_3", props -> new SpeedUpgradeItem((Item.Properties)props, 3)).lang("Tier 3 Extraction Speed Upgrade").tab(EIOCreativeTabs.CONDUITS).register();
    public static final ItemEntry<SpeedUpgradeItem> EXTRACTION_SPEED_UPGRADE_4 = REGISTRATE.item("extraction_speed_upgrade_4", props -> new SpeedUpgradeItem((Item.Properties)props, 4)).lang("Tier 4 Extraction Speed Upgrade").tab(EIOCreativeTabs.CONDUITS).register();
    public static final ItemEntry<RedstoneFilterItem> NOT_FILTER = ConduitItems.createRedstoneFilter("redstone_not_filter", "Redstone NOT Filter", stack -> RedstoneNOTFilter.INSTANCE, null);
    public static final ItemEntry<RedstoneFilterItem> OR_FILTER = ConduitItems.createRedstoneFilter("redstone_or_filter", "Redstone OR Filter", RedstoneORFilter::new, () -> ConduitMenus.REDSTONE_DOUBLE_CHANNEL_FILTER.get());
    public static final ItemEntry<RedstoneFilterItem> AND_FILTER = ConduitItems.createRedstoneFilter("redstone_and_filter", "Redstone AND Filter", RedstoneANDFilter::new, () -> ConduitMenus.REDSTONE_DOUBLE_CHANNEL_FILTER.get());
    public static final ItemEntry<RedstoneFilterItem> NOR_FILTER = ConduitItems.createRedstoneFilter("redstone_nor_filter", "Redstone NOR Filter", RedstoneNORFilter::new, () -> ConduitMenus.REDSTONE_DOUBLE_CHANNEL_FILTER.get());
    public static final ItemEntry<RedstoneFilterItem> NAND_FILTER = ConduitItems.createRedstoneFilter("redstone_nand_filter", "Redstone NAND Filter", RedstoneNANDFilter::new, () -> ConduitMenus.REDSTONE_DOUBLE_CHANNEL_FILTER.get());
    public static final ItemEntry<RedstoneFilterItem> XOR_FILTER = ConduitItems.createRedstoneFilter("redstone_xor_filter", "Redstone XOR Filter", RedstoneXORFilter::new, () -> ConduitMenus.REDSTONE_DOUBLE_CHANNEL_FILTER.get());
    public static final ItemEntry<RedstoneFilterItem> XNOR_FILTER = ConduitItems.createRedstoneFilter("redstone_xnor_filter", "Redstone XNOR Filter", RedstoneXNORFilter::new, () -> ConduitMenus.REDSTONE_DOUBLE_CHANNEL_FILTER.get());
    public static final ItemEntry<RedstoneFilterItem> TLATCH_FILTER = ConduitItems.createRedstoneFilter("redstone_toggle_filter", "Redstone Toggle Filter", RedstoneTLatchFilter::new, null);
    public static final ItemEntry<RedstoneFilterItem> COUNT_FILTER = ConduitItems.createRedstoneFilter("redstone_counting_filter", "Redstone Counting Filter", RedstoneCountFilter::new, () -> ConduitMenus.REDSTONE_COUNT_FILTER.get());
    public static final ItemEntry<RedstoneFilterItem> SENSOR_FILTER = ConduitItems.createRedstoneFilter("redstone_sensor_filter", "Redstone Sensor Filter", stack -> RedstoneSensorFilter.INSTANCE, null);
    public static final ItemEntry<RedstoneFilterItem> TIMER_FILTER = ConduitItems.createRedstoneFilter("redstone_timer_filter", "Redstone Timer Filter", RedstoneTimerFilter::new, () -> ConduitMenus.REDSTONE_TIMER_FILTER.get());
    public static final ItemEntry<ConduitProbeItem> CONDUIT_PROBE = REGISTRATE.item("conduit_probe", ConduitProbeItem::new).lang("Conduit Probe").model((ctx, prov) -> {
        ResourceLocation generatedItem = new ResourceLocation("item/generated");
        ((ItemModelBuilder)((ItemModelBuilder)prov.withExistingParent(ctx.getName(), generatedItem)).texture("layer0", EnderIO.loc("item/conduit_probe_probe"))).override().predicate(EnderIO.loc("conduit_probe_state"), (float)ConduitProbeItem.State.PROBE.ordinal()).model((ModelFile)((ItemModelBuilder)prov.withExistingParent("conduit_probe_probe", generatedItem)).texture("layer0", EnderIO.loc("item/conduit_probe_probe"))).end().override().predicate(EnderIO.loc("conduit_probe_state"), (float)ConduitProbeItem.State.COPY_PASTE.ordinal()).model((ModelFile)((ItemModelBuilder)prov.withExistingParent("conduit_probe_copy", generatedItem)).texture("layer0", EnderIO.loc("item/conduit_probe_copy"))).end();
    }).tab(EIOCreativeTabs.GEAR).properties(props -> props.m_41487_(1)).register();

    private static ItemEntry<Item> createConduitItem(Supplier<? extends ConduitType<?>> type, String itemName) {
        return REGISTRATE.item(itemName + "_conduit", properties -> ConduitItemFactory.build(type, properties)).tab(EIOCreativeTabs.CONDUITS).model((ctx, prov) -> {
            ResourceLocation conduitTypeKey = ConduitType.getKey((ConduitType)type.get());
            ((ItemModelBuilder)prov.withExistingParent(ctx.getName(), EnderIO.loc("item/conduit"))).texture("0", EnderIO.loc("block/conduit/" + conduitTypeKey.m_135815_()));
        }).register();
    }

    public static ItemEntry<RedstoneFilterItem> createRedstoneFilter(String name, String englishName, Function<ItemStack, ResourceFilter> capabilityFactory, Supplier<MenuType<?>> menu) {
        return REGISTRATE.item(name, properties -> new RedstoneFilterItem((Item.Properties)properties, capabilityFactory, menu)).lang(englishName).tab(EIOCreativeTabs.GEAR).register();
    }

    public static void register() {
    }
}

