/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.conduits.client.model.conduit.modifier;

import com.enderio.EnderIO;
import com.enderio.api.conduit.model.ConduitCoreModelModifier;
import com.enderio.conduits.common.conduit.type.fluid.FluidConduitData;
import com.enderio.core.client.RenderUtil;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.client.model.IQuadTransformer;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.Nullable;

public class FluidConduitCoreModelModifier
implements ConduitCoreModelModifier<FluidConduitData> {
    public static final FluidConduitCoreModelModifier INSTANCE = new FluidConduitCoreModelModifier();
    private static final ResourceLocation FLUID_MODEL = EnderIO.loc("block/extra/fluids");

    @Override
    public List<BakedQuad> createConnectionQuads(FluidConduitData data, @Nullable Direction facing, Direction connectionDirection, RandomSource rand, @Nullable RenderType type) {
        if (!data.isMultiFluid && data.lockedFluid() != null) {
            return new FluidPaintQuadTransformer(data.lockedFluid()).process(Minecraft.m_91087_().m_91304_().getModel(FLUID_MODEL).getQuads(Blocks.f_50652_.m_49966_(), facing, rand, ModelData.EMPTY, type));
        }
        return List.of();
    }

    @Override
    public List<ResourceLocation> getModelDependencies() {
        return List.of(FLUID_MODEL);
    }

    private record FluidPaintQuadTransformer(Fluid fluid) implements IQuadTransformer
    {
        public void processInPlace(BakedQuad quad) {
            IClientFluidTypeExtensions clientExtension = IClientFluidTypeExtensions.of((Fluid)this.fluid);
            TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(clientExtension.getStillTexture());
            for (int i = 0; i < 4; ++i) {
                float[] uv0 = RenderUtil.unpackVertices(quad.m_111303_(), i, IQuadTransformer.UV0, 2);
                uv0[0] = (uv0[0] - quad.m_173410_().m_118409_()) * (float)sprite.m_245424_().m_246492_() / (float)quad.m_173410_().m_245424_().m_245330_() + sprite.m_118409_();
                uv0[1] = (uv0[1] - quad.m_173410_().m_118411_()) * (float)sprite.m_245424_().m_246492_() / (float)quad.m_173410_().m_245424_().m_245330_() + sprite.m_118411_();
                int[] packedTextureData = RenderUtil.packUV(uv0[0], uv0[1]);
                quad.m_111303_()[IQuadTransformer.UV0 + i * IQuadTransformer.STRIDE] = packedTextureData[0];
                quad.m_111303_()[IQuadTransformer.UV0 + 1 + i * IQuadTransformer.STRIDE] = packedTextureData[1];
                RenderUtil.putColorARGB(quad.m_111303_(), i, clientExtension.getTintColor());
            }
            quad.f_111295_ = sprite;
        }
    }
}

