/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.network.packets;

import dev.hexnowloading.dungeonnowloading.network.ClientUtil;
import dev.hexnowloading.dungeonnowloading.network.DNLPacket;
import dev.hexnowloading.dungeonnowloading.screen.ClientScreens;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.DyeColor;

public class S2CPedestalOpenEditorPacket
implements DNLPacket {
    private final BlockPos pos;
    private final List<Component> lines;
    private final int colorId;
    private final boolean glowing;

    public S2CPedestalOpenEditorPacket(BlockPos pos, List<Component> lines, DyeColor color, boolean glowing) {
        this.pos = pos.m_7949_();
        this.lines = lines;
        this.colorId = color.m_41060_();
        this.glowing = glowing;
    }

    public S2CPedestalOpenEditorPacket(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        int n = buf.m_130242_();
        ArrayList<Component> tmp = new ArrayList<Component>(n);
        for (int i = 0; i < n; ++i) {
            tmp.add(buf.m_130238_());
        }
        this.lines = tmp;
        this.colorId = buf.m_130242_();
        this.glowing = buf.readBoolean();
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.m_130130_(this.lines.size());
        for (Component c : this.lines) {
            buf.m_130083_(c);
        }
        buf.m_130130_(this.colorId);
        buf.writeBoolean(this.glowing);
    }

    public static S2CPedestalOpenEditorPacket decode(FriendlyByteBuf buf) {
        return new S2CPedestalOpenEditorPacket(buf);
    }

    @Override
    public void handle(@Nullable ServerPlayer sender) {
        Minecraft mc = ClientUtil.getClient();
        if (mc == null) {
            return;
        }
        DyeColor color = DyeColor.m_41053_((int)this.colorId);
        mc.execute(() -> ClientScreens.openPedestalEditor(this.pos, this.lines, color == null ? DyeColor.BLACK : color, this.glowing));
    }
}

