/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.entity.projectile;

import dev.hexnowloading.dungeonnowloading.block.VertexPillarBlock;
import dev.hexnowloading.dungeonnowloading.entity.boss.FairkeeperSerpentEntity;
import dev.hexnowloading.dungeonnowloading.entity.projectile.VertexOrbProjectileEntity;
import dev.hexnowloading.dungeonnowloading.entity.util.ModelledProjectileEntity;
import dev.hexnowloading.dungeonnowloading.entity.util.ProjectileUtils;
import dev.hexnowloading.dungeonnowloading.particle.type.ScalableAxisParticleType;
import dev.hexnowloading.dungeonnowloading.registry.DNLBlocks;
import dev.hexnowloading.dungeonnowloading.registry.DNLEntityTypes;
import dev.hexnowloading.dungeonnowloading.registry.DNLParticleTypes;
import dev.hexnowloading.dungeonnowloading.registry.DNLSounds;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class VertexPillarProjectileEntity
extends ModelledProjectileEntity {
    private static final float IMPACT_RANGE = 3.0f;
    private static final float DAMAGE = 5.0f;
    private static final float SHILED_DAMAGE_REDUCTION = 0.55f;
    private static final boolean SHIELD_PENETRATION = true;
    private static final int LIFETIME = 1000;
    private static final int LIFETIME_AFTER_LANDING = 3;
    private int tickCount = 1000;
    private int destroyCount;
    private boolean hasLanded = false;
    private boolean canSummonVertexOrb;
    private float damagePercentage;

    public VertexPillarProjectileEntity(EntityType<? extends VertexPillarProjectileEntity> entityType, Level level) {
        super(entityType, level);
    }

    public VertexPillarProjectileEntity(Level level, LivingEntity livingEntity, float damagePercentage) {
        this((EntityType<? extends VertexPillarProjectileEntity>)DNLEntityTypes.VERTEX_PILLAR_PROJECTILE.get(), level);
        this.setOwner((Entity)livingEntity);
        this.damagePercentage = damagePercentage;
        this.canSummonVertexOrb = false;
    }

    public VertexPillarProjectileEntity(Level level, LivingEntity livingEntity, float damagePercentage, boolean canSummonVertexOrb) {
        this((EntityType<? extends VertexPillarProjectileEntity>)DNLEntityTypes.VERTEX_PILLAR_PROJECTILE.get(), level);
        this.setOwner((Entity)livingEntity);
        this.damagePercentage = damagePercentage;
        this.canSummonVertexOrb = canSummonVertexOrb;
    }

    protected void m_8097_() {
    }

    @Override
    protected void tickProjectile() {
        ProjectileUtils.checkAndUnloadProjectile(this);
        if (!this.m_20068_()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.04, 0.0));
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
        if (this.m_20096_()) {
            if (this.m_9236_().f_46443_) {
                return;
            }
            if (!this.hasLanded && !this.m_9236_().m_8055_(this.m_20183_().m_7495_()).m_204336_(BlockTags.f_13070_) && this.destroyCount < 5 && this.m_9236_().m_46953_(this.m_20183_().m_7495_(), false, (Entity)this)) {
                ++this.destroyCount;
                return;
            }
            if (!this.hasLanded) {
                AABB aabb = this.m_20191_().m_82400_(3.0);
                List targets = this.m_9236_().m_45976_(LivingEntity.class, aabb);
                for (LivingEntity mob : targets) {
                    this.pushNearbyMobs(mob);
                }
                if (this.m_9236_().m_8055_(this.m_20183_().m_7495_()).m_60713_(this.getPillarBlock())) {
                    this.breakLogic();
                    this.m_146870_();
                    return;
                }
                this.placePillarBlock();
                this.tickCount = 3;
                this.hasLanded = true;
            }
            if (this.tickCount <= 0) {
                this.m_146870_();
                return;
            }
            --this.tickCount;
        } else {
            if (this.tickCount <= 0) {
                this.m_146870_();
            }
            --this.tickCount;
        }
        this.m_20256_(this.m_20184_().m_82490_(0.98));
    }

    private void breakLogic() {
        if (this.m_9236_().f_46443_) {
            return;
        }
        this.m_9236_().m_46961_(this.m_20183_().m_7495_(), false);
        if (this.canSummonVertexOrb) {
            VertexOrbProjectileEntity vertexOrbProjectileEntity = new VertexOrbProjectileEntity(this.m_9236_(), (LivingEntity)this.m_19749_(), 2);
            vertexOrbProjectileEntity.shoot(this.m_20185_(), this.m_20186_() - 2.0, this.m_20189_(), this.m_20185_(), vertexOrbProjectileEntity.m_20186_() - 1.0, this.m_20189_(), 1.0f, 0.02f);
            this.m_9236_().m_7967_((Entity)vertexOrbProjectileEntity);
        }
    }

    private void pushNearbyMobs(LivingEntity mob) {
        Player player;
        float actualDamage = 5.0f;
        if (mob instanceof FairkeeperSerpentEntity) {
            return;
        }
        Entity entity = this.m_19749_();
        if (entity instanceof LivingEntity) {
            LivingEntity owner = (LivingEntity)entity;
            actualDamage = (float)owner.m_21133_(Attributes.f_22281_) * this.damagePercentage;
        }
        if (mob instanceof Player && (player = (Player)mob).m_21254_()) {
            player.m_36384_(true);
            actualDamage *= 0.45f;
        }
        double x = mob.m_20185_() - this.m_20185_();
        double z = mob.m_20189_() - this.m_20189_();
        double a = x * x + z * z;
        mob.m_5997_(x / a * 6.0, (double)0.2f, z / a * 6.0);
        mob.m_6469_(this.m_269291_().m_269299_((Entity)this, (LivingEntity)this.m_19749_()), actualDamage);
    }

    protected Block getPillarBlock() {
        return DNLBlocks.VERTEX_PILLAR.get();
    }

    protected void placePillarBlock() {
        this.m_9236_().m_7731_(this.m_20183_(), DNLBlocks.VERTEX_PILLAR.get().m_49966_(), 3);
        this.m_9236_().m_7731_(this.m_20183_().m_7494_(), (BlockState)DNLBlocks.VERTEX_PILLAR.get().m_49966_().m_61124_((Property)BlockStateProperties.f_61401_, (Comparable)DoubleBlockHalf.UPPER), 3);
        VertexPillarBlock.linkOnPlaced(this.m_9236_(), this.m_20183_());
        ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)new ScalableAxisParticleType.ScalableAxisParticleData(DNLParticleTypes.WHITE_SHOCKWAVE_PARTICLE.get(), 0, 90.0f, 5.0f), (double)((float)this.m_20183_().m_123341_() + 0.5f), (double)((float)this.m_20183_().m_123342_() + 0.01f), (double)((float)this.m_20183_().m_123343_() + 0.5f), 1, 0.0, 0.0, 0.0, 0.0);
        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), DNLSounds.FAIRKEEPER_OUROS_PILLAR_LAND.get(), this.m_5720_(), 3.0f, 1.0f);
    }
}

