/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.entity.monster;

import dev.hexnowloading.dungeonnowloading.entity.ai.AllRangeMeleeAttackGoal;
import dev.hexnowloading.dungeonnowloading.entity.ai.ScuttleFlameThrowerAttackGoal;
import dev.hexnowloading.dungeonnowloading.entity.ai.SlumberingEntityLookAtPlayerGoal;
import dev.hexnowloading.dungeonnowloading.entity.ai.SlumberingEntityPlayerTargetGoal;
import dev.hexnowloading.dungeonnowloading.entity.ai.SlumberingEntityRandomStrollGoal;
import dev.hexnowloading.dungeonnowloading.entity.projectile.FlameProjectileEntity;
import dev.hexnowloading.dungeonnowloading.entity.util.EntityStates;
import dev.hexnowloading.dungeonnowloading.entity.util.SlumberingEntity;
import dev.hexnowloading.dungeonnowloading.particle.type.ScalableParticleType;
import dev.hexnowloading.dungeonnowloading.registry.DNLParticleTypes;
import dev.hexnowloading.dungeonnowloading.registry.DNLSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class ScuttleEntity
extends Monster
implements Enemy,
SlumberingEntity {
    private static final EntityDataAccessor<ScuttleState> STATE = SynchedEntityData.m_135353_(ScuttleEntity.class, EntityStates.SCUTTLE_STATE);
    private int aiTick = 0;
    private int renderOldTick;
    private boolean renderHeating;
    private boolean renderCooling;
    private float oldAgeInTicks;
    private boolean rotateStarted;
    private int flamePosOldTick;
    private boolean mouthOpeningStarted;
    private boolean mouthClosingStarted;
    public final AnimationState wakingUpAnimationState = new AnimationState();
    public final AnimationState mouthOpenAnimationState = new AnimationState();
    public final AnimationState mouthCloseAnimationState = new AnimationState();
    public final AnimationState idleClosedAnimationState = new AnimationState();
    public final AnimationState idleOpenedAnimationState = new AnimationState();
    public final AnimationState blockFormAnimationState = new AnimationState();
    private static final byte TRIGGER_WAKING_UP_ANIMATION_BYTE = 70;
    private static final byte TRIGGER_MOUTH_OPEN_ANIMATION_BYTE = 71;
    private static final byte TRIGGER_MOUTH_CLOSE_ANIMATION_BYTE = 72;
    private static final byte TRIGGER_IDLE_CLOSED_ANIMATION_BYTE = 73;
    private static final byte TRIGGER_IDLE_OPENED_ANIMATION_BYTE = 74;
    private static final byte TRIGGER_BLOCK_FORM_ANIMATION_BYTE = 75;
    private static final byte TRIGGER_ANIMATION_STOP_BYTE = 76;

    public ScuttleEntity(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
        this.setState(ScuttleState.SLUMBERING);
        this.f_21364_ = 20;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 50.0).m_22268_(Attributes.f_22281_, 15.0).m_22268_(Attributes.f_22282_, 1.25).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22278_, 0.5).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22284_, 20.0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new ScuttleFlameThrowerAttackGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new AllRangeMeleeAttackGoal((PathfinderMob)this, 1.0, true, 1.1f));
        this.f_21345_.m_25352_(3, (Goal)new MoveTowardsRestrictionGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new SlumberingEntityRandomStrollGoal((PathfinderMob)this, 0.5));
        this.f_21345_.m_25352_(5, (Goal)new SlumberingEntityLookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21346_.m_25352_(2, (Goal)new SlumberingEntityPlayerTargetGoal((Mob)this));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(STATE, (Object)ScuttleState.SLUMBERING);
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128379_("Slumbering", this.isSlumbering());
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        boolean isSlumbering = compoundTag.m_128471_("Slumbering");
        this.f_19804_.m_135381_(STATE, (Object)(isSlumbering ? ScuttleState.SLUMBERING : ScuttleState.CLOSED));
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().m_5776_()) {
            return;
        }
        double LOWER_FLAME_HEIGHT = 2.3;
        double HIGHER_FLAME_HEIGHT = 3.0;
        switch (this.getState()) {
            case OPENING: {
                float timeInSeconds;
                if (!this.isMouthOpeningStarted()) {
                    this.setFlamePosOldTick(this.f_19797_);
                    this.setMouthOpeningStarted(true);
                }
                float time = (timeInSeconds = ((float)this.f_19797_ - (float)this.getFlamePosOldTick()) / 20.0f - 0.38f) > 0.0f ? timeInSeconds / 0.19999999f : 0.0f;
                double height = time < 1.0f ? LOWER_FLAME_HEIGHT + (HIGHER_FLAME_HEIGHT - LOWER_FLAME_HEIGHT) * (double)time : HIGHER_FLAME_HEIGHT;
                this.animateParticles(0.03f, height, 0.1);
                break;
            }
            case OPENED: {
                this.setMouthOpeningStarted(false);
                this.animateParticles(0.2f, HIGHER_FLAME_HEIGHT, 0.7);
                ScalableParticleType.ScalableParticleData particleData = new ScalableParticleType.ScalableParticleData(DNLParticleTypes.LARGE_FLAME_PARTICLE.get(), 1.0f);
                this.m_9236_().m_7106_((ParticleOptions)particleData, this.m_20185_() + ((double)this.m_217043_().m_188501_() - 0.5) * 0.3, this.m_20186_() + HIGHER_FLAME_HEIGHT + 0.3 + ((double)this.m_217043_().m_188501_() - 0.5) * 0.3, this.m_20189_() + ((double)this.m_217043_().m_188501_() - 0.5) * 0.3, 0.0, 0.0, 0.0);
                break;
            }
            case CLOSING: {
                float timeInSeconds;
                if (!this.isMouthClosingStarted()) {
                    this.setFlamePosOldTick(this.f_19797_);
                    this.setMouthClosingStarted(true);
                }
                float time = (timeInSeconds = ((float)this.f_19797_ - (float)this.getFlamePosOldTick()) / 20.0f - 0.38f) > 0.0f ? timeInSeconds / 0.08000001f : 0.0f;
                double height = time < 1.0f ? HIGHER_FLAME_HEIGHT - (HIGHER_FLAME_HEIGHT - LOWER_FLAME_HEIGHT) * (double)time : LOWER_FLAME_HEIGHT;
                this.animateParticles(0.03f, height, 0.1);
                break;
            }
            default: {
                this.setMouthClosingStarted(false);
                this.animateParticles(0.03f, LOWER_FLAME_HEIGHT, 0.1);
            }
        }
    }

    private void animateParticles(float chance, double height, double spread) {
        ScalableParticleType.ScalableParticleData particleData = new ScalableParticleType.ScalableParticleData(DNLParticleTypes.LARGE_FLAME_PARTICLE.get(), 1.0f);
        this.m_9236_().m_7107_((ParticleOptions)particleData, this.m_20185_() + ((double)this.m_217043_().m_188501_() - 0.5) * spread, this.m_20186_() + height + ((double)this.m_217043_().m_188501_() - 0.5) * 0.3, this.m_20189_() + ((double)this.m_217043_().m_188501_() - 0.5) * spread, 0.0, 0.0, 0.0);
        if (this.m_217043_().m_188501_() < chance) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123756_, this.m_20185_() + ((double)this.m_217043_().m_188501_() - 0.5) * 0.3, this.m_20186_() + height + ((double)this.m_217043_().m_188501_() - 0.5) * 0.3, this.m_20189_() + ((double)this.m_217043_().m_188501_() - 0.5) * 0.3, 0.0, 0.0, 0.0);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123777_, this.m_20185_() + ((double)this.m_217043_().m_188501_() - 0.5) * 0.3, this.m_20186_() + height + ((double)this.m_217043_().m_188501_() - 0.5) * 0.3, this.m_20189_() + ((double)this.m_217043_().m_188501_() - 0.5) * 0.3, 0.0, 0.02, 0.0);
        }
    }

    protected void m_8024_() {
        if (this.isSlumbering()) {
            this.setState(ScuttleState.AWAKENING);
            this.triggerWakingUpAnimation();
            this.m_216990_(DNLSounds.SCUTTLE_WAKING.get());
            this.aiTick = 72;
        }
        if (this.isState(ScuttleState.AWAKENING)) {
            if (this.aiTick > 0) {
                --this.aiTick;
            } else {
                this.setState(ScuttleState.CLOSED);
                this.triggerIdleClosedAnimation();
            }
        }
        super.m_8024_();
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        return super.m_6518_(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, compoundTag);
    }

    protected float m_6431_(Pose pose, EntityDimensions entityDimensions) {
        return 1.45f;
    }

    public boolean m_6469_(DamageSource damageSource, float damage) {
        if (!this.isAttackingState() && damageSource.m_7640_() instanceof AbstractArrow) {
            return false;
        }
        if (damageSource.m_7640_() instanceof FlameProjectileEntity) {
            return false;
        }
        boolean hurtFr = super.m_6469_(damageSource, damage);
        if (hurtFr) {
            this.playDeflectSound();
        }
        return hurtFr;
    }

    public boolean m_5829_() {
        return this.isSlumbering();
    }

    public void m_7822_(byte b) {
        switch (b) {
            case 70: {
                this.wakingUpAnimationState.m_216977_(this.f_19797_);
                break;
            }
            case 71: {
                this.mouthOpenAnimationState.m_216977_(this.f_19797_);
                break;
            }
            case 72: {
                this.idleOpenedAnimationState.m_216973_();
                this.mouthCloseAnimationState.m_216977_(this.f_19797_);
                break;
            }
            case 73: {
                this.idleClosedAnimationState.m_216977_(this.f_19797_);
                break;
            }
            case 74: {
                this.mouthOpenAnimationState.m_216973_();
                this.idleClosedAnimationState.m_216973_();
                this.idleOpenedAnimationState.m_216977_(this.f_19797_);
                break;
            }
            case 75: {
                this.blockFormAnimationState.m_216977_(this.f_19797_);
                break;
            }
            case 76: {
                this.resetAnimations();
                break;
            }
            default: {
                super.m_7822_(b);
            }
        }
    }

    private void resetAnimations() {
        this.wakingUpAnimationState.m_216973_();
        this.mouthOpenAnimationState.m_216973_();
        this.mouthCloseAnimationState.m_216973_();
        this.idleOpenedAnimationState.m_216973_();
        this.idleClosedAnimationState.m_216973_();
        this.blockFormAnimationState.m_216973_();
    }

    public void playDeflectSound() {
        this.m_5496_(DNLSounds.SCUTTLE_DEFLECT.get(), 1.0f, 1.0f);
    }

    public void playShootingOpenSound() {
        this.m_5496_(DNLSounds.SCUTTLE_SHOOTING_OPEN.get(), 1.5f, 1.0f);
    }

    public void playShootingChargeSound() {
        this.m_5496_(DNLSounds.SCUTTLE_SHOOTING_CHARGE.get(), 1.5f, 1.0f);
    }

    public void playShootingBurstSound() {
        this.m_5496_(DNLSounds.SCUTTLE_SHOOTING_BURST.get(), 1.5f, 1.0f);
    }

    public void playShootingFlameSound() {
        this.m_5496_(DNLSounds.SCUTTLE_SHOOTING_FLAME.get(), 1.5f, 1.0f);
    }

    public void playShootingStopSound() {
        this.m_5496_(DNLSounds.SCUTTLE_SHOOTING_STOP.get(), 1.5f, 1.0f);
    }

    public void playShootingCloseSound() {
        this.m_5496_(DNLSounds.SCUTTLE_SHOOTING_CLOSE.get(), 1.5f, 1.0f);
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return DNLSounds.SCUTTLE_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return DNLSounds.SCUTTLE_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return DNLSounds.SCUTTLE_DEATH.get();
    }

    protected void m_7355_(BlockPos blockPos, BlockState blockState) {
        this.m_5496_(DNLSounds.SCUTTLE_STEP.get(), 0.5f, 1.0f);
    }

    public void setRenderOldTick(int tick) {
        this.renderOldTick = tick;
    }

    public int getRenderOldTick() {
        return this.renderOldTick;
    }

    public void setRenderHeating(boolean b) {
        this.renderHeating = b;
    }

    public boolean isRenderHeating() {
        return this.renderHeating;
    }

    public void setRenderCooling(boolean b) {
        this.renderCooling = b;
    }

    public boolean isRenderCooling() {
        return this.renderCooling;
    }

    public void setOldAgeInTicks(float tick) {
        this.oldAgeInTicks = tick;
    }

    public float getOldAgeInTicks() {
        return this.oldAgeInTicks;
    }

    public void setRotateStarted(boolean b) {
        this.rotateStarted = b;
    }

    public boolean isRotateStarted() {
        return this.rotateStarted;
    }

    public int getFlamePosOldTick() {
        return this.flamePosOldTick;
    }

    public void setFlamePosOldTick(int flamePosOldTick) {
        this.flamePosOldTick = flamePosOldTick;
    }

    public boolean isMouthOpeningStarted() {
        return this.mouthOpeningStarted;
    }

    public void setMouthOpeningStarted(boolean mouthOpeningStarted) {
        this.mouthOpeningStarted = mouthOpeningStarted;
    }

    public boolean isMouthClosingStarted() {
        return this.mouthClosingStarted;
    }

    public void setMouthClosingStarted(boolean mouthClosingStarted) {
        this.mouthClosingStarted = mouthClosingStarted;
    }

    public void setState(ScuttleState scuttleState) {
        this.f_19804_.m_135381_(STATE, (Object)scuttleState);
    }

    public ScuttleState getState() {
        return (ScuttleState)((Object)this.f_19804_.m_135370_(STATE));
    }

    public boolean isState(ScuttleState scuttleState) {
        return this.getState().equals((Object)scuttleState);
    }

    public boolean isAttackingState() {
        return this.getState().equals((Object)ScuttleState.OPENING) || this.getState().equals((Object)ScuttleState.OPENED) || this.getState().equals((Object)ScuttleState.CLOSING);
    }

    public void triggerWakingUpAnimation() {
        this.m_9236_().m_7605_((Entity)this, (byte)70);
    }

    public void triggerMouthOpenAnimation() {
        this.m_9236_().m_7605_((Entity)this, (byte)71);
    }

    public void triggerMouthCloseAnimation() {
        this.m_9236_().m_7605_((Entity)this, (byte)72);
    }

    public void triggerIdleOpenedAnimation() {
        this.m_9236_().m_7605_((Entity)this, (byte)74);
    }

    public void triggerIdleClosedAnimation() {
        this.m_9236_().m_7605_((Entity)this, (byte)73);
    }

    public void triggerBlockFormAnimation() {
        this.m_9236_().m_7605_((Entity)this, (byte)75);
    }

    public void triggerAnimationStop() {
        this.m_9236_().m_7605_((Entity)this, (byte)76);
    }

    @Override
    public boolean isStationary() {
        return this.getState().equals((Object)ScuttleState.SLUMBERING) || this.getState().equals((Object)ScuttleState.AWAKENING) || this.getState().equals((Object)ScuttleState.OPENING) || this.getState().equals((Object)ScuttleState.OPENED) || this.getState().equals((Object)ScuttleState.CLOSING);
    }

    @Override
    public boolean isSlumbering() {
        return this.isState(ScuttleState.SLUMBERING);
    }

    public static enum ScuttleState {
        SLUMBERING,
        AWAKENING,
        CLOSED,
        OPENING,
        OPENED,
        CLOSING;

    }
}

