/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.entity.misc;

import dev.hexnowloading.dungeonnowloading.entity.ai.EntityBodyRotationControl;
import dev.hexnowloading.dungeonnowloading.entity.util.EntityStates;
import dev.hexnowloading.dungeonnowloading.item.RepulsorItem;
import dev.hexnowloading.dungeonnowloading.item.ScrapItem;
import dev.hexnowloading.dungeonnowloading.particle.type.ScalableParticleType;
import dev.hexnowloading.dungeonnowloading.registry.DNLEnchantments;
import dev.hexnowloading.dungeonnowloading.registry.DNLItems;
import dev.hexnowloading.dungeonnowloading.registry.DNLParticleTypes;
import dev.hexnowloading.dungeonnowloading.registry.DNLSounds;
import dev.hexnowloading.dungeonnowloading.registry.DNLTags;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class RepulsorEntity
extends Mob {
    public static final int SHIELD_MAX_HEALTH = 100;
    public static final float SHIELD_ALERT_THRESHOLD = 50.0f;
    private static final double BEAM_INITIAL_PARTICLE_SPACING = 0.5;
    private static final float BEAM_INITIAL_PARTICLE_SCALE_MIN = 0.1f;
    private static final float BEAM_INITIAL_PARTICLE_SCALE_MAX = 0.3f;
    private static final int SHIELD_HEAL_AMOUNT = 5;
    private static final EntityDataAccessor<Boolean> DATA_CAN_RENDER = SynchedEntityData.m_135353_(RepulsorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> DATA_AGE = SynchedEntityData.m_135353_(RepulsorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_SHIELD_HEALTH = SynchedEntityData.m_135353_(RepulsorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<State> DATA_STATE = SynchedEntityData.m_135353_(RepulsorEntity.class, EntityStates.COMMAND_PYLON_STATE);
    private static final EntityDataAccessor<Skin> DATA_SKIN = SynchedEntityData.m_135353_(RepulsorEntity.class, EntityStates.REPULSOR_SKIN);
    private static final EntityDataAccessor<Boolean> DATA_SKIN_VALIDATION = SynchedEntityData.m_135353_(RepulsorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public AnimationState setupAnimState = new AnimationState();
    public AnimationState idleAnimState = new AnimationState();
    public AnimationState rechargeAnimState = new AnimationState();
    private Set<ThrownTrident> processedTridents = new HashSet<ThrownTrident>();
    private int rechargeAnimDuration;
    private ItemStack sourceStack = ItemStack.f_41583_;

    public RepulsorEntity(EntityType<? extends Mob> $$0, Level $$1) {
        super($$0, $$1);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return PathfinderMob.m_21552_().m_22268_(Attributes.f_22276_, 1.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_CAN_RENDER, (Object)false);
        this.f_19804_.m_135372_(DATA_AGE, (Object)0);
        this.f_19804_.m_135372_(DATA_SHIELD_HEALTH, (Object)100);
        this.f_19804_.m_135372_(DATA_STATE, (Object)State.SETUP);
        this.f_19804_.m_135372_(DATA_SKIN, (Object)Skin.DEFAULT);
        this.f_19804_.m_135372_(DATA_SKIN_VALIDATION, (Object)false);
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.f_19804_.m_135381_(DATA_CAN_RENDER, (Object)compoundTag.m_128471_("canRender"));
        this.f_19804_.m_135381_(DATA_AGE, (Object)compoundTag.m_128451_("age"));
        this.f_19804_.m_135381_(DATA_SHIELD_HEALTH, (Object)compoundTag.m_128451_("shieldHealth"));
        if (compoundTag.m_128441_("skin") && !this.getSkinValidation()) {
            this.f_19804_.m_135381_(DATA_SKIN, (Object)Skin.fromId(compoundTag.m_128461_("skin")));
        }
        this.sourceStack = compoundTag.m_128425_("SourceStack", 10) ? ItemStack.m_41712_((CompoundTag)compoundTag.m_128469_("SourceStack")) : ItemStack.f_41583_;
        this.setSkinValidation(true);
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128379_("canRender", this.canRender());
        compoundTag.m_128405_("age", this.getAge());
        compoundTag.m_128405_("shieldHealth", ((Integer)this.f_19804_.m_135370_(DATA_SHIELD_HEALTH)).intValue());
        compoundTag.m_128359_("skin", this.getSkin().getId());
        if (!this.sourceStack.m_41619_()) {
            CompoundTag s = new CompoundTag();
            this.sourceStack.m_41739_(s);
            compoundTag.m_128365_("SourceStack", (Tag)s);
        }
    }

    public void m_7334_(Entity entity) {
    }

    public boolean m_6094_() {
        return false;
    }

    protected boolean m_20073_() {
        return false;
    }

    public boolean m_6063_() {
        return false;
    }

    public PushReaction m_7752_() {
        this.dropItem(null);
        this.m_146870_();
        return PushReaction.NORMAL;
    }

    protected InteractionResult m_6071_(Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.m_21120_(interactionHand);
        if (itemStack.m_150930_(Items.f_42451_) && this.getAge() >= 35 && this.getShieldHealth() < 100 && this.rechargeAnimDuration <= 0) {
            if (this.getShieldHealth() >= 95) {
                this.m_5496_(DNLSounds.REPULSOR_RECHARGE.get(), 0.5f, 0.5f);
            } else {
                this.m_5496_(DNLSounds.REPULSOR_RECHARGE.get(), 0.5f, 1.0f);
            }
            this.rechargeAnimDuration = 10;
            if (!this.m_9236_().f_46443_) {
                itemStack.m_41774_(1);
                this.setShieldHealth(this.getShieldHealth() + 5);
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(player, interactionHand);
    }

    protected BodyRotationControl m_7560_() {
        return new EntityBodyRotationControl(this);
    }

    public boolean m_142559_() {
        return super.m_142559_();
    }

    public boolean m_6469_(DamageSource damageSource, float f) {
        if (this.m_6673_(damageSource)) {
            return false;
        }
        if (!this.m_213877_() && !this.m_9236_().f_46443_) {
            this.m_146870_();
            this.m_5834_();
            this.dropItem(damageSource.m_7639_());
        }
        return true;
    }

    public void m_5997_(double d, double e, double f) {
        if (!this.m_9236_().f_46443_ && !this.m_213877_() && d * d + e * e + f * f > 0.0) {
            this.m_146870_();
            this.dropItem(null);
        }
    }

    public void dropItem(@Nullable Entity entity) {
        if (this.m_9236_().m_46469_().m_46207_(GameRules.f_46137_)) {
            this.m_216990_(DNLSounds.REPULSOR_BREAK.get());
            if (entity instanceof Player) {
                Player player = (Player)entity;
                if (player.m_150110_().f_35937_) {
                    return;
                }
            }
            ItemStack itemStack = this.sourceStack.m_41619_() ? new ItemStack((ItemLike)DNLItems.REPULSOR.get()) : this.sourceStack.m_41777_();
            itemStack.m_41764_(1);
            int damage = 100 - (Integer)this.f_19804_.m_135370_(DATA_SHIELD_HEALTH);
            itemStack.m_41721_(damage);
            if (this.getSkin() == Skin.GOLDEN) {
                RepulsorItem.setGolden(itemStack);
            }
            this.m_19983_(itemStack);
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.getAge() == 1) {
            this.setupAnimState.m_216977_(this.f_19797_);
            this.f_19804_.m_135381_(DATA_STATE, (Object)State.SETUP);
            this.f_19804_.m_135381_(DATA_CAN_RENDER, (Object)true);
            this.m_216990_(DNLSounds.REPULSOR_PLACE.get());
        } else if (this.getAge() == 36) {
            this.m_216990_(DNLSounds.REPULSOR_BARRIER_BUILD.get());
        } else if (this.getAge() == 76) {
            this.setupAnimState.m_216973_();
            this.f_19804_.m_135381_(DATA_STATE, (Object)State.IDLE);
        }
        if ((float)this.getAge() >= 76.0f) {
            this.idleAnimState.m_216982_(this.f_19797_);
        }
        if (this.rechargeAnimDuration-- > 0) {
            this.rechargeAnimState.m_216982_(this.f_19797_);
            if (this.rechargeAnimDuration <= 0) {
                this.rechargeAnimState.m_216973_();
            }
        }
        if (!this.m_9236_().f_46443_) {
            if (this.getAge() >= 36) {
                for (Entity entity : this.getNearbyProjectiles()) {
                    boolean aboveHalfHealth;
                    boolean discardEntity = false;
                    boolean bl = aboveHalfHealth = (float)((Integer)this.f_19804_.m_135370_(DATA_SHIELD_HEALTH)).intValue() > 50.0f;
                    if (entity instanceof ThrownTrident) {
                        ThrownTrident thrownTrident = (ThrownTrident)entity;
                        if (this.processedTridents.contains(thrownTrident) || thrownTrident.f_36703_) continue;
                        this.processedTridents.add(thrownTrident);
                        Vec3 motion = thrownTrident.m_20184_();
                        thrownTrident.m_20256_(new Vec3(-motion.f_82479_ * (double)0.1f, -motion.f_82480_ * (double)0.1f, -motion.f_82481_ * (double)0.1f));
                        thrownTrident.f_19812_ = true;
                    } else if (entity instanceof ThrownPotion) {
                        boolean flag;
                        ThrownPotion thrownPotion = (ThrownPotion)entity;
                        ItemStack itemStack = thrownPotion.m_7846_();
                        Potion potion = PotionUtils.m_43579_((ItemStack)itemStack);
                        List list = PotionUtils.m_43547_((ItemStack)itemStack);
                        boolean bl2 = flag = potion == Potions.f_43599_ && list.isEmpty();
                        if (flag) {
                            thrownPotion.m_37552_();
                        } else if (!list.isEmpty()) {
                            if (itemStack.m_150930_(Items.f_42739_)) {
                                thrownPotion.m_37537_(itemStack, potion);
                            } else {
                                thrownPotion.m_37547_(list, null);
                            }
                        }
                        int i = potion.m_43491_() ? 2007 : 2002;
                        this.m_9236_().m_46796_(i, thrownPotion.m_20183_(), PotionUtils.m_43575_((ItemStack)itemStack));
                        discardEntity = true;
                    } else {
                        if (entity instanceof AbstractArrow) {
                            AbstractArrow arrow = (AbstractArrow)entity;
                            if (arrow.f_36703_) continue;
                        }
                        discardEntity = true;
                    }
                    this.spawnRedstoneBeamParticle((ServerLevel)this.m_9236_(), entity);
                    this.m_216990_(DNLSounds.REPULSOR_FIZZLE.get());
                    int shieldDamage = 1;
                    if (entity.m_6095_().m_204039_(DNLTags.REPULSOR_HIGH_DAMAGE_PROJECTILES)) {
                        shieldDamage = 20;
                    } else if (entity.m_6095_().m_204039_(DNLTags.REPULSOR_LOW_DAMAGE_PROJECTILES)) {
                        shieldDamage = 5;
                    }
                    int updatedShieldHealth = (Integer)this.f_19804_.m_135370_(DATA_SHIELD_HEALTH) - shieldDamage;
                    this.f_19804_.m_135381_(DATA_SHIELD_HEALTH, (Object)updatedShieldHealth);
                    if (aboveHalfHealth && (float)this.getShieldHealth() <= 50.0f) {
                        this.m_216990_(DNLSounds.REPULSOR_ALERT.get());
                    }
                    if (discardEntity) {
                        entity.m_146870_();
                    }
                    if (!((float)updatedShieldHealth <= 0.0f)) continue;
                    ScalableParticleType.ScalableParticleData particleData = new ScalableParticleType.ScalableParticleData(DNLParticleTypes.REDSTONE_SHOCKWAVE_PARTICLE.get(), 1.0f);
                    this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11913_, this.m_5720_(), 1.0f, 2.0f);
                    ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)particleData, this.m_20185_(), this.m_20186_(), this.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
                    this.maybeDropScrapOnUsedUp();
                    this.m_146870_();
                    return;
                }
                if ((float)this.getShieldHealth() <= 50.0f) {
                    float healthRatio = (float)this.getShieldHealth() / 50.0f;
                    float blinkCycle = 40.0f - 35.0f * (1.0f - healthRatio);
                    if (this.getAge() % (int)blinkCycle == 0) {
                        float normalizedSpeed = 1.0f - (blinkCycle - 5.0f) / 35.0f;
                        float pitch = 1.0f + normalizedSpeed;
                        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), DNLSounds.REPULSOR_BLINK.get(), SoundSource.BLOCKS, 0.5f, pitch);
                    }
                }
            }
            this.f_19804_.m_135381_(DATA_AGE, (Object)(this.getAge() + 1));
        }
    }

    private void spawnRedstoneBeamParticle(ServerLevel level, Entity target) {
        Vec3 start = this.m_20182_().m_82520_(0.0, 1.0, 0.0);
        Vec3 end = target.m_20182_().m_82520_(0.0, (double)target.m_20206_() * 0.5, 0.0);
        Vec3 direction = end.m_82546_(start);
        double distance = direction.m_82553_();
        double stepSize = 0.5;
        int particleCount = (int)(distance / stepSize);
        Vec3 step = direction.m_82541_().m_82490_(stepSize);
        float particleScale = 0.1f + (float)Math.random() * 0.20000002f;
        ScalableParticleType.ScalableParticleData particleData = new ScalableParticleType.ScalableParticleData(DNLParticleTypes.REDSTONE_SHOCKWAVE_PARTICLE.get(), particleScale);
        for (int i = 0; i <= particleCount; ++i) {
            Vec3 particlePos = start.m_82549_(step.m_82490_((double)i));
            if (i == particleCount) {
                particleData = new ScalableParticleType.ScalableParticleData(DNLParticleTypes.REDSTONE_SHOCKWAVE_PARTICLE.get(), 0.5f);
            }
            level.m_8767_((ParticleOptions)particleData, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    private List<Entity> getNearbyProjectiles() {
        double centerX = this.m_20185_();
        double centerY = this.m_20186_();
        double centerZ = this.m_20189_();
        AABB detectionBox = new AABB(centerX - 4.5, centerY - 4.5, centerZ - 4.5, centerX + 4.5, centerY + 4.5, centerZ + 4.5);
        return this.m_9236_().m_6249_((Entity)null, detectionBox, entity -> (entity instanceof Projectile || entity.m_6095_().m_204039_(DNLTags.PROJECTILES) || entity instanceof ThrownPotion) && !entity.m_6095_().m_204039_(DNLTags.REPULSOR_OMITTED_PROJECTILES));
    }

    public boolean canRender() {
        return (Boolean)this.f_19804_.m_135370_(DATA_CAN_RENDER);
    }

    public int getAge() {
        return (Integer)this.f_19804_.m_135370_(DATA_AGE);
    }

    public State getState() {
        return (State)((Object)this.f_19804_.m_135370_(DATA_STATE));
    }

    public int getShieldHealth() {
        return (Integer)this.f_19804_.m_135370_(DATA_SHIELD_HEALTH);
    }

    public void setShieldHealth(int health) {
        this.f_19804_.m_135381_(DATA_SHIELD_HEALTH, (Object)health);
    }

    public Skin getSkin() {
        return (Skin)((Object)this.f_19804_.m_135370_(DATA_SKIN));
    }

    public void setSkin(Skin skin) {
        this.f_19804_.m_135381_(DATA_SKIN, (Object)skin);
    }

    public void setCosmeticMode(String id) {
        this.setSkin(Skin.fromId(id));
    }

    public boolean getSkinValidation() {
        return (Boolean)this.f_19804_.m_135370_(DATA_SKIN_VALIDATION);
    }

    public void setSkinValidation(boolean v) {
        this.f_19804_.m_135381_(DATA_SKIN_VALIDATION, (Object)v);
    }

    public void setSourceStack(ItemStack stack) {
        this.sourceStack = stack.m_41777_();
    }

    public ItemStack getSourceStack() {
        return this.sourceStack;
    }

    private void maybeDropScrapOnUsedUp() {
        if (!this.m_9236_().m_46469_().m_46207_(GameRules.f_46137_)) {
            return;
        }
        if (this.m_9236_().f_46443_) {
            return;
        }
        if (this.sourceStack.m_41619_()) {
            return;
        }
        if (EnchantmentHelper.m_44843_((Enchantment)DNLEnchantments.BREAK_PROTECTION.get(), (ItemStack)this.sourceStack) <= 0) {
            return;
        }
        ItemStack original = this.sourceStack.m_41777_();
        original.m_41721_(original.m_41776_());
        ItemStack scrap = ScrapItem.ofOriginal(original);
        this.m_19983_(scrap);
    }

    public static enum State {
        SETUP,
        IDLE;

    }

    public static enum Skin {
        DEFAULT("default"),
        GOLDEN("golden");

        public final String id;

        private Skin(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public static Skin fromId(String id) {
            for (Skin s : Skin.values()) {
                if (!s.id.equalsIgnoreCase(id)) continue;
                return s;
            }
            return DEFAULT;
        }
    }
}

