/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.entity.ai;

import dev.hexnowloading.dungeonnowloading.entity.monster.BallistaGolemEntity;
import dev.hexnowloading.dungeonnowloading.entity.projectile.BallistaArrowEntity;
import dev.hexnowloading.dungeonnowloading.registry.DNLSounds;
import java.util.EnumSet;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;

public class BallistaGolemArrowAttackGoal
extends Goal {
    private final BallistaGolemEntity ballistaGolemEntity;
    private int nextScanTick;
    private int attackTicks;
    private static final float FACING_THRESHOLD = 15.0f;

    public BallistaGolemArrowAttackGoal(BallistaGolemEntity ballistaGolemEntity) {
        this.ballistaGolemEntity = ballistaGolemEntity;
        this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
    }

    private int nextStartTick() {
        return BallistaGolemArrowAttackGoal.m_186073_((int)10);
    }

    private int nextCooldownStartTick() {
        return BallistaGolemArrowAttackGoal.m_186073_((int)(60 + this.ballistaGolemEntity.m_217043_().m_188503_(40)));
    }

    public boolean m_8036_() {
        if (this.nextScanTick > 0) {
            --this.nextScanTick;
            return false;
        }
        double DETECTION_RANGE = this.ballistaGolemEntity.getFollowDistance();
        boolean hasTargetInRange = this.ballistaGolemEntity.m_5448_() != null && (double)this.ballistaGolemEntity.m_5448_().m_20270_((Entity)this.ballistaGolemEntity) < DETECTION_RANGE && this.ballistaGolemEntity.m_5448_().m_20270_((Entity)this.ballistaGolemEntity) > 7.0f;
        boolean isFacingTarget = this.ballistaGolemEntity.m_5448_() != null && this.isFacingTarget(this.ballistaGolemEntity.m_5448_());
        this.nextScanTick = this.nextStartTick();
        return this.ballistaGolemEntity.isState(BallistaGolemEntity.BallistaGolemState.IDLE) && hasTargetInRange && this.ballistaGolemEntity.getBallistaArrowCount() > 0 && this.ballistaGolemEntity.m_5448_().m_142582_((Entity)this.ballistaGolemEntity) && isFacingTarget;
    }

    public boolean m_8045_() {
        return this.ballistaGolemEntity.isState(BallistaGolemEntity.BallistaGolemState.SHOOT);
    }

    public void m_8056_() {
        this.ballistaGolemEntity.setState(BallistaGolemEntity.BallistaGolemState.SHOOT);
        this.ballistaGolemEntity.triggerShootAnimation();
        this.attackTicks = BallistaGolemArrowAttackGoal.m_186073_((int)69);
        this.ballistaGolemEntity.m_5496_(DNLSounds.BALLISTA_GOLEM_SHOOT.get(), 1.5f, 1.0f);
    }

    public void m_8037_() {
        if (this.attackTicks > 0) {
            --this.attackTicks;
        } else {
            this.ballistaGolemEntity.setState(BallistaGolemEntity.BallistaGolemState.IDLE);
            this.ballistaGolemEntity.triggerIdleAnimation();
            this.nextScanTick = this.nextCooldownStartTick();
            return;
        }
        if (this.attackTicks == BallistaGolemArrowAttackGoal.m_186073_((int)44)) {
            double viewDistance = 1.5;
            Vec3 viewVector = this.ballistaGolemEntity.m_20252_(1.0f);
            double d0 = viewVector.f_82479_ * viewDistance;
            double d1 = viewVector.f_82480_ * viewDistance;
            double d2 = viewVector.f_82481_ * viewDistance;
            BallistaArrowEntity projectile = new BallistaArrowEntity((LivingEntity)this.ballistaGolemEntity, this.ballistaGolemEntity.m_9236_());
            projectile.m_6034_(this.ballistaGolemEntity.m_20185_() + d0, this.ballistaGolemEntity.m_20188_() - 0.28 + d1, this.ballistaGolemEntity.m_20189_() + d2);
            projectile.m_37251_((Entity)this.ballistaGolemEntity, this.ballistaGolemEntity.m_146909_(), this.ballistaGolemEntity.m_146908_(), 0.0f, 2.0f, 0.1f);
            this.ballistaGolemEntity.m_9236_().m_7967_((Entity)projectile);
            this.ballistaGolemEntity.setBallistaArrowCount(this.ballistaGolemEntity.getBallistaArrowCount() - 1);
        }
    }

    private boolean isFacingTarget(LivingEntity target) {
        if (target == null) {
            return false;
        }
        double deltaX = target.m_20185_() - this.ballistaGolemEntity.m_20185_();
        double deltaZ = target.m_20189_() - this.ballistaGolemEntity.m_20189_();
        float targetYaw = (float)(Math.toDegrees(Math.atan2(deltaZ, deltaX)) - 90.0);
        float angleDifference = Math.abs(Mth.m_14177_((float)(this.ballistaGolemEntity.m_146908_() - targetYaw)));
        return angleDifference < 15.0f;
    }
}

