/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.block.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import dev.hexnowloading.dungeonnowloading.block.client.StatueSkinCache;
import dev.hexnowloading.dungeonnowloading.block.client.model.PlayerStatueModel;
import dev.hexnowloading.dungeonnowloading.block.client.model.PlayerStatuePedestalModel;
import dev.hexnowloading.dungeonnowloading.block.entity.PlayerStatueBlockEntity;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class PlayerStatueRenderer
implements BlockEntityRenderer<PlayerStatueBlockEntity> {
    private final PlayerStatueModel statue;
    private final PlayerStatuePedestalModel pedestal;
    private final Font font;
    private static final ResourceLocation PEDESTAL_TEX = new ResourceLocation("dungeonnowloading", "textures/block/player_statue_pedestal.png");
    private static final ResourceLocation PEDESTAL_TEX_COPPER_NOTCH = new ResourceLocation("dungeonnowloading", "textures/block/player_statue_pedestal_copper_notch.png");
    private static final ResourceLocation PEDESTAL_TEX_IRON_NOTCH = new ResourceLocation("dungeonnowloading", "textures/block/player_statue_pedestal_iron_notch.png");
    private static final ResourceLocation PEDESTAL_TEX_GOLD_NOTCH = new ResourceLocation("dungeonnowloading", "textures/block/player_statue_pedestal_gold_notch.png");
    private static final ResourceLocation PEDESTAL_TEX_DIAMOND_NOTCH = new ResourceLocation("dungeonnowloading", "textures/block/player_statue_pedestal_diamond_notch.png");
    private static final ResourceLocation STONE_OVERLAY_TEX = new ResourceLocation("dungeonnowloading", "textures/block/player_statue_stone.png");
    private static final float TEXT_MARGIN_BLOCKS = 0.0625f;
    private static final float FACE_WIDTH_BLOCKS = 0.875f;
    private static final float TEXT_SCALE = 0.010416667f;
    private static final float TEXT_Y = 0.25f;
    private static final float TEXT_Z = 0.5005f;
    public static final int PEDESTAL_TEXT_MAX_PX = 100;

    public PlayerStatueRenderer(BlockEntityRendererProvider.Context ctx) {
        this.statue = new PlayerStatueModel(ctx.m_173582_(PlayerStatueModel.LAYER_LOCATION));
        this.pedestal = new PlayerStatuePedestalModel(ctx.m_173582_(PlayerStatuePedestalModel.LAYER_LOCATION));
        this.font = ctx.m_173586_();
    }

    public void render(PlayerStatueBlockEntity be, float pt, PoseStack pose, MultiBufferSource buf, int light, int overlay) {
        float pedestalYaw;
        pose.m_85836_();
        pose.m_85837_(0.5, 0.0, 0.5);
        BlockState state = be.m_58900_();
        int rot16 = state.m_61138_((Property)BlockStateProperties.f_61390_) ? (Integer)state.m_61143_((Property)BlockStateProperties.f_61390_) : 0;
        float statueYaw = 180.0f - (float)rot16 * 22.5f;
        if (state.m_61138_((Property)HorizontalDirectionalBlock.f_54117_)) {
            Direction f = (Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
            pedestalYaw = 180.0f - f.m_122435_();
        } else {
            int cardinal = (rot16 + 2) / 4 * 4;
            pedestalYaw = 180.0f - (float)cardinal * 22.5f;
        }
        pose.m_85836_();
        pose.m_252781_(Axis.f_252436_.m_252977_(pedestalYaw));
        pose.m_252880_(0.0f, 1.5005f, 0.0f);
        pose.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        pose.m_252781_(Axis.f_252529_.m_252977_(180.0f));
        VertexConsumer pedVx = buf.m_6299_(RenderType.m_110458_((ResourceLocation)PEDESTAL_TEX));
        this.pedestal.renderPedestal(pose, pedVx, light, overlay);
        ResourceLocation notchTex = this.notchOverlayTex(be);
        if (notchTex != null) {
            pose.m_85836_();
            pose.m_85841_(1.001f, 1.001f, 1.001f);
            VertexConsumer overlayVx = buf.m_6299_(RenderType.m_110458_((ResourceLocation)notchTex));
            this.pedestal.renderPedestal(pose, overlayVx, light, overlay);
            pose.m_85849_();
        }
        pose.m_85849_();
        pose.m_85836_();
        pose.m_252781_(Axis.f_252436_.m_252977_(statueYaw));
        pose.m_252880_(0.0f, 1.75f, 0.0f);
        pose.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        pose.m_252781_(Axis.f_252529_.m_252977_(180.0f));
        StatueSkinCache.StatueSkin skin = StatueSkinCache.get(be.getOwner(), 0.6f, STONE_OVERLAY_TEX);
        this.statue.useSlimArms(skin.slim());
        VertexConsumer statVx = buf.m_6299_(RenderType.m_110431_((ResourceLocation)skin.texture()));
        this.statue.m_7695_(pose, statVx, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
        pose.m_85849_();
        this.renderPedestalText(be, pose, buf, light, pedestalYaw);
        pose.m_85849_();
    }

    private void renderPedestalText(PlayerStatueBlockEntity be, PoseStack pose, MultiBufferSource buf, int worldLight, float pedestalYaw) {
        boolean outlineVisible;
        int packedLight;
        int argbText;
        Component lineComp = be.getLine(0);
        if (lineComp == null) {
            return;
        }
        List seqs = this.font.m_92923_((FormattedText)lineComp, 4096);
        if (seqs.isEmpty()) {
            return;
        }
        FormattedCharSequence seq = (FormattedCharSequence)seqs.get(0);
        boolean glowing = be.isGlowingText();
        int baseRGB = be.getTextColor() != null ? be.getTextColor().m_41071_() : 0;
        int darkColor = PlayerStatueRenderer.getDarkColorLikeSigns(baseRGB, glowing);
        if (glowing) {
            argbText = 0xFF000000 | baseRGB;
            packedLight = 0xF000F0;
            outlineVisible = PlayerStatueRenderer.isOutlineVisibleLikeSigns(be.m_58899_(), baseRGB);
        } else {
            argbText = 0xFF000000 | darkColor;
            packedLight = worldLight;
            outlineVisible = false;
        }
        pose.m_85836_();
        pose.m_252781_(Axis.f_252436_.m_252977_(pedestalYaw));
        pose.m_252880_(0.0f, 0.25f, -0.5005f);
        pose.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        pose.m_85841_(0.010416667f, -0.010416667f, 0.010416667f);
        int w = this.font.m_92724_((FormattedCharSequence)seqs.get(0));
        float fit = w > 100 ? 100.0f / (float)w : 1.0f;
        pose.m_85841_(fit, fit, fit);
        float x = (float)(-this.font.m_92724_((FormattedCharSequence)seqs.get(0))) / 2.0f;
        Objects.requireNonNull(this.font);
        float y = (float)(-9) / 2.0f;
        if (outlineVisible) {
            this.font.m_168645_((FormattedCharSequence)seqs.get(0), x, y, argbText, darkColor, pose.m_85850_().m_252922_(), buf, packedLight);
        } else {
            this.font.m_272191_((FormattedCharSequence)seqs.get(0), x, y, argbText, false, pose.m_85850_().m_252922_(), buf, Font.DisplayMode.POLYGON_OFFSET, 0, packedLight);
        }
        pose.m_85849_();
    }

    private static boolean isOutlineVisibleLikeSigns(BlockPos pos, int rgb) {
        if (rgb == DyeColor.BLACK.m_41071_()) {
            return true;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player != null && mc.f_91066_.m_92176_().m_90612_() && player.m_150108_()) {
            return true;
        }
        Entity cam = mc.m_91288_();
        return cam != null && cam.m_20238_(Vec3.m_82512_((Vec3i)pos)) < 256.0;
    }

    private static int getDarkColorLikeSigns(int rgb, boolean glowing) {
        if (rgb == DyeColor.BLACK.m_41071_() && glowing) {
            return -988212;
        }
        int r = (int)((double)FastColor.ARGB32.m_13665_((int)rgb) * 0.4);
        int g = (int)((double)FastColor.ARGB32.m_13667_((int)rgb) * 0.4);
        int b = (int)((double)FastColor.ARGB32.m_13669_((int)rgb) * 0.4);
        return FastColor.ARGB32.m_13660_((int)0, (int)r, (int)g, (int)b);
    }

    public static int pedestalMaxTextPixels(Font font) {
        return 100;
    }

    private ResourceLocation notchOverlayTex(PlayerStatueBlockEntity be) {
        return switch (be.getNotchTier()) {
            default -> throw new IncompatibleClassChangeError();
            case PlayerStatueBlockEntity.NotchTier.COPPER -> PEDESTAL_TEX_COPPER_NOTCH;
            case PlayerStatueBlockEntity.NotchTier.IRON -> PEDESTAL_TEX_IRON_NOTCH;
            case PlayerStatueBlockEntity.NotchTier.GOLD -> PEDESTAL_TEX_GOLD_NOTCH;
            case PlayerStatueBlockEntity.NotchTier.DIAMOND -> PEDESTAL_TEX_DIAMOND_NOTCH;
            case PlayerStatueBlockEntity.NotchTier.NONE -> null;
        };
    }
}

