/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.mc;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.zip.ZipEntry;
import net.minecraft.FileUtil;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.resources.Resource;
import team.creative.creativecore.CreativeCore;
import team.creative.creativecore.common.util.mc.PlatformResourceUtils;
import team.creative.creativecore.mixin.FilePackResourcesAccessor;
import team.creative.creativecore.mixin.PathPackResourcesAccessor;
import team.creative.creativecore.mixin.VanillaPackResourcesAccessor;

public class ResourceUtils {
    public static long length(PackType type, Resource resource, ResourceLocation location) {
        return ResourceUtils.length(type, resource.m_247173_(), location);
    }

    public static long length(PackType type, PackResources source, ResourceLocation location) {
        if (source instanceof FilePackResourcesAccessor) {
            FilePackResourcesAccessor zip = (FilePackResourcesAccessor)source;
            ZipEntry entry = zip.getZipFile().getEntry(FilePackResourcesAccessor.callGetPathFromLocation(type, location));
            if (entry != null) {
                return entry.getSize();
            }
            return 0L;
        }
        long length = PlatformResourceUtils.length(type, source, location);
        if (length > 0L) {
            return length;
        }
        Path path = (Path)FileUtil.m_245538_((String)location.m_135815_()).get().map(x -> {
            if (source instanceof VanillaPackResourcesAccessor) {
                VanillaPackResourcesAccessor vanilla = (VanillaPackResourcesAccessor)source;
                return ResourceUtils.resolve(vanilla.getPathsForType().get(type), location, x);
            }
            if (source instanceof PathPackResourcesAccessor) {
                PathPackResourcesAccessor pack = (PathPackResourcesAccessor)source;
                return FileUtil.m_245247_((Path)pack.getRoot().resolve(type.m_10305_()).resolve(location.m_135827_()), (List)x);
            }
            return PlatformResourceUtils.resolvePath(type, source, location, x);
        }, x -> {
            CreativeCore.LOGGER.error("Invalid path {}: {}", (Object)location, (Object)x.message());
            return null;
        });
        if (path != null) {
            return path.toFile().length();
        }
        return 0L;
    }

    private static Path resolve(List<Path> rootPaths, ResourceLocation location, List<String> parts) {
        for (Path path : rootPaths) {
            Path path1 = FileUtil.m_245247_((Path)path.resolve(location.m_135827_()), parts);
            if (!Files.exists(path1, new LinkOption[0]) || !PathPackResources.m_246877_((Path)path1)) continue;
            return path1;
        }
        return null;
    }
}

