/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.covers1624.quack.util.CrashLock;
import net.minecraft.ChatFormatting;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Deprecated
public class BCProfiler {
    private static final CrashLock LOCK = new CrashLock("Already Initialized.");
    public static ProfilerInstance RENDER = new ProfilerInstance("Render");
    public static ProfilerInstance TICK = new ProfilerInstance("Tick");
    public static boolean enableProfiler = false;
    public static List<String> renderDebug = new ArrayList<String>();
    public static List<String> tickDebug = new ArrayList<String>();
    private String thread;
    private Map<String, PNode> nodes = new HashMap<String, PNode>();
    private Map<String, long[]> timings = new HashMap<String, long[]>();
    private PNode rootNode;
    private String mode;
    private PNode activeNode;
    private int timingIndex = 0;
    private int timingTicks = 100;

    public static void init() {
        LOCK.lock();
        MinecraftForge.EVENT_BUS.register((Object)new BCProfiler());
    }

    @SubscribeEvent
    public void clientTick(TickEvent.ClientTickEvent event) {
        if (!enableProfiler || event.phase != TickEvent.Phase.END) {
            return;
        }
        tickDebug.clear();
        TICK.dumpDebug(tickDebug);
        TICK.update();
    }

    @SubscribeEvent
    public void renderWorldLast(RenderLevelStageEvent event) {
        if (!enableProfiler || event.getStage() != RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            return;
        }
        renderDebug.clear();
        RENDER.dumpDebug(renderDebug);
        RENDER.update();
    }

    @SubscribeEvent
    public void render(RenderGuiOverlayEvent.Post event) {
    }

    private BCProfiler() {
    }

    private BCProfiler(String thread, String mode) {
        this.thread = thread;
        this.rootNode = new PNode(thread, this, null);
        this.mode = mode;
        this.activeNode = this.rootNode;
    }

    private void dumpTimigs(List<String> list) {
        this.rootNode.dumpTimings(list, "");
    }

    private void startNode(String name) {
        PNode node;
        String nodeName = (String)(this.activeNode == null ? "" : this.activeNode.name + ".") + name;
        this.activeNode = node = this.nodes.computeIfAbsent(nodeName, s -> new PNode((String)s, this, this.activeNode));
        node.start();
    }

    private void stopNode() {
        if (this.activeNode != null) {
            this.activeNode.stop();
            this.activeNode = this.activeNode.parent;
        }
    }

    private void update() {
        ++this.timingIndex;
        if (this.timingIndex == this.timingTicks) {
            this.timingIndex = 0;
        }
        for (long[] times : this.timings.values()) {
            times[this.timingIndex] = 0L;
        }
        this.rootNode.update();
    }

    private void addTime(String node, long time) {
        long[] times = this.timings.computeIfAbsent(node, s -> new long[this.timingTicks]);
        int n = this.timingIndex;
        times[n] = times[n] + time;
    }

    public static class ProfilerInstance {
        private final Map<Thread, BCProfiler> threadProfilers = Collections.synchronizedMap(new HashMap());
        private String mode;

        ProfilerInstance(String mode) {
            this.mode = mode;
        }

        public synchronized void start(String name) {
            if (!enableProfiler) {
                return;
            }
            Thread t = Thread.currentThread();
            this.threadProfilers.computeIfAbsent(t, thread -> new BCProfiler(thread.getName(), this.mode)).startNode(name);
        }

        public synchronized void stop() {
            if (!enableProfiler) {
                return;
            }
            Thread t = Thread.currentThread();
            BCProfiler p = this.threadProfilers.get(t);
            if (p != null) {
                p.stopNode();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void update() {
            Map<Thread, BCProfiler> map = this.threadProfilers;
            synchronized (map) {
                this.threadProfilers.entrySet().removeIf(e -> !((Thread)e.getKey()).isAlive());
                this.threadProfilers.forEach((t, p) -> p.update());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void dumpDebug(List<String> list) {
            Map<Thread, BCProfiler> map = this.threadProfilers;
            synchronized (map) {
                for (BCProfiler p : this.threadProfilers.values()) {
                    p.dumpTimigs(list);
                }
            }
        }
    }

    private static class PNode {
        private String name;
        private BCProfiler profiler;
        private PNode parent;
        private List<PNode> children = new ArrayList<PNode>();
        private long startTime = -1L;
        private boolean isDead = false;

        public PNode(String name, BCProfiler profiler, PNode parent) {
            this.name = name;
            this.profiler = profiler;
            this.parent = parent;
            if (parent != null) {
                parent.children.add(this);
            }
        }

        private void start() {
            this.startTime = System.nanoTime();
        }

        private void stop() {
            this.profiler.addTime(this.name, System.nanoTime() - this.startTime);
        }

        private void update() {
            this.children.forEach(PNode::update);
            this.children.removeIf(PNode::checkDead);
        }

        private boolean checkDead() {
            if (this.isDead) {
                this.profiler.nodes.remove(this.name);
            }
            return this.isDead;
        }

        private void dumpTimings(List<String> list, String inset) {
            long[] times = this.profiler.timings.get(this.name);
            if (times == null) {
                list.add(inset + this.name + ": " + this.profiler.mode);
            } else {
                long min = Long.MAX_VALUE;
                long max = 0L;
                long average = 0L;
                for (long time : times) {
                    if (time < min && time > 0L) {
                        min = time;
                    }
                    if (time > max) {
                        max = time;
                    }
                    average += time;
                }
                if (min == Long.MAX_VALUE) {
                    min = 0L;
                }
                this.isDead = average == 0L;
                list.add(inset + this.name.replace(this.parent.name + ".", "") + String.format(": (%s, %s, %s)", ChatFormatting.GREEN + (double)min / 1000.0 + "us" + ChatFormatting.RESET, ChatFormatting.RED + (double)max / 1000.0 + "us" + ChatFormatting.RESET, ChatFormatting.YELLOW + (double)(average /= (long)times.length) / 1000.0 + "us" + ChatFormatting.RESET));
            }
            this.children.forEach(pNode -> pNode.dumpTimings(list, inset + "  "));
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof PNode && ((PNode)obj).name.equals(this.name);
        }
    }
}

