/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui;

import codechicken.lib.gui.modular.ModularGui;
import codechicken.lib.gui.modular.ModularGuiScreen;
import codechicken.lib.gui.modular.elements.GuiButton;
import codechicken.lib.gui.modular.elements.GuiElement;
import codechicken.lib.gui.modular.lib.BackgroundRender;
import codechicken.lib.gui.modular.lib.Constraints;
import codechicken.lib.gui.modular.lib.CursorHelper;
import codechicken.lib.gui.modular.lib.GuiProvider;
import codechicken.lib.gui.modular.lib.GuiRender;
import codechicken.lib.gui.modular.lib.geometry.ConstrainedGeometry;
import codechicken.lib.gui.modular.lib.geometry.GuiParent;
import com.brandon3055.brandonscore.api.hud.AbstractHudElement;
import com.brandon3055.brandonscore.client.BCGuiTextures;
import com.brandon3055.brandonscore.client.gui.GuiToolkit;
import com.brandon3055.brandonscore.client.hud.HudData;
import com.brandon3055.brandonscore.client.hud.HudManager;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.Color;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.joml.Matrix4f;

public class HudConfigGui
implements GuiProvider {
    protected GuiToolkit toolkit = new GuiToolkit("gui.brandonscore.hud_config");

    public void buildGui(ModularGui gui) {
        gui.initFullscreenGui();
        gui.renderScreenBackground(false);
        gui.setGuiTitle((Component)Component.m_237115_((String)"gui.brandonscore.hud_config.name"));
        GuiElement root = gui.getRoot();
        GuiElement<?> title = this.toolkit.floatingHeading(gui);
        Constraints.placeInside(title, (ConstrainedGeometry)root, (Constraints.LayoutPos)Constraints.LayoutPos.TOP_CENTER, (double)0.0, (double)15.0);
        for (AbstractHudElement element : HudManager.getHudElements().values()) {
            new ElementHandler((GuiParent<?>)root, element);
        }
        gui.onClose(HudData::saveIfDirty);
        gui.onKeyPressPost((key, scancode, modifiers) -> {
            InputConstants.Key input = InputConstants.m_84827_((int)key, (int)scancode);
            if (gui.mc().f_91066_.f_92092_.isActiveAndMatches(input)) {
                gui.getScreen().m_7379_();
            }
        });
    }

    private class ElementHandler
    extends GuiElement<ElementHandler>
    implements BackgroundRender {
        private AbstractHudElement element;
        private float borderAnim;
        private float bgAnim;
        private int tick;
        boolean dragging;
        private GuiButton settings;

        public ElementHandler(GuiParent<?> parent, AbstractHudElement element) {
            super(parent);
            this.borderAnim = 0.0f;
            this.bgAnim = 0.0f;
            this.tick = 0;
            this.dragging = false;
            this.element = element;
            Constraints.size((ConstrainedGeometry)this, element::width, element::height);
            Constraints.pos((ConstrainedGeometry)this, element::xPos, element::yPos);
            this.settings = HudConfigGui.this.toolkit.createIconButton((GuiParent<?>)this, 10, BCGuiTextures.getter("dark/gear"));
            this.settings.setTooltip(new Component[]{HudConfigGui.this.toolkit.translate("settings", new Object[0])});
            Constraints.placeInside((ConstrainedGeometry)this.settings, (ConstrainedGeometry)this, (Constraints.LayoutPos)Constraints.LayoutPos.TOP_RIGHT, (double)-2.0, (double)2.0);
            this.settings.onPress(() -> element.createConfigDialog((GuiElement<?>)this.settings).setNormalizedPos(this.settings.xMax(), this.settings.yMin()).setCloseOnItemClicked(false));
            String infoKey = String.format("hud.%s.%s.info", HudManager.HUD_REGISTRY.getKey((Object)element).m_135827_(), HudManager.HUD_REGISTRY.getKey((Object)element).m_135815_());
            String translatedInfo = I18n.m_118938_((String)infoKey, (Object[])new Object[0]);
            if (!infoKey.equals(translatedInfo)) {
                GuiButton infoButton = HudConfigGui.this.toolkit.createIconButton((GuiParent<?>)this, 10, BCGuiTextures.getter("dark/info_icon"));
                Constraints.placeInside((ConstrainedGeometry)infoButton, (ConstrainedGeometry)this, (Constraints.LayoutPos)Constraints.LayoutPos.TOP_LEFT, (double)2.0, (double)2.0);
                infoButton.setTooltip(new Component[]{Component.m_237113_((String)translatedInfo)});
                infoButton.setTooltipDelay(0);
            }
        }

        public void renderBackground(GuiRender render, double mouseX, double mouseY, float partialTicks) {
            int rgb = Color.HSBtoRGB(((float)this.tick + partialTicks) / 200.0f, 1.0f, 1.0f);
            this.drawBackground(render, this.xMin(), this.yMin(), this.xSize(), this.ySize(), partialTicks, rgb);
            if (this.bgAnim > 0.0f) {
                MutableComponent name = Component.m_237115_((String)String.format("hud.%s.%s.name", HudManager.HUD_REGISTRY.getKey((Object)this.element).m_135827_(), HudManager.HUD_REGISTRY.getKey((Object)this.element).m_135815_()));
                float bgAnim = Math.min(this.bgAnim + partialTicks * 0.1f, 1.0f);
                render.drawCenteredString((Component)name, (double)((float)this.xCenter()), (double)((float)this.yCenter() - 2.0f), 0xFFFFFF | (int)(255.0f * bgAnim) << 24, false);
            }
        }

        public void tick(double mouseX, double mouseY) {
            if (this.borderAnim < 1.0f) {
                this.borderAnim += 0.1f;
            } else if (this.bgAnim < 1.0f) {
                this.bgAnim += 0.1f;
            }
            ++this.tick;
            if (this.isMouseOver() && this.getChildren().stream().noneMatch(GuiElement::isMouseOver)) {
                this.getModularGui().setCursor(CursorHelper.DRAG);
            }
            super.tick(mouseX, mouseY);
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            boolean captured = super.mouseClicked(mouseX, mouseY, button);
            if (!captured && this.isMouseOver()) {
                this.dragging = true;
                this.element.startMoving(mouseX, mouseY);
                return true;
            }
            return captured;
        }

        public void mouseMoved(double mouseX, double mouseY) {
            if (this.dragging) {
                this.element.onDragged(mouseX, mouseY);
            }
            super.mouseMoved(mouseX, mouseY);
        }

        public boolean mouseReleased(double mouseX, double mouseY, int button) {
            if (this.dragging) {
                this.element.stopMoving();
                this.dragging = false;
            }
            return super.mouseReleased(mouseX, mouseY, button);
        }

        private void drawBackground(GuiRender render, double x, double y, double w, double h, float partialTicks, int colour) {
            double p;
            double sh;
            double sw;
            float borderAnim = this.borderAnim + partialTicks * 0.1f;
            float bgAnim = Math.min(this.bgAnim + partialTicks * 0.1f, 1.0f);
            render.rect(this.getRectangle(), (int)(143.0f * bgAnim) << 24);
            VertexConsumer buffer = render.buffers().m_6299_(GuiRender.SOLID);
            Matrix4f mat = render.pose().m_85850_().m_252922_();
            double boarderLength = w * 2.0 + h * 2.0;
            double bp = boarderLength * (double)borderAnim;
            if (bp > 0.0) {
                sw = Math.min(w, bp);
                this.drawGradientQuad(buffer, mat, x, y, x + sw, y, x + sw - 1.0, y + 1.0, x + 1.0, y + 1.0, -16777216, colour);
                this.drawGradientQuad(buffer, mat, x + 1.0, y + 1.0, x + sw - 1.0, y + 1.0, x + sw - 2.0, y + 2.0, x + 2.0, y + 2.0, colour, -16777216);
            }
            if (bp - w > 0.0) {
                sh = Math.min(h, bp - w);
                double p2 = sh / h;
                this.drawGradientQuad(buffer, mat, x + w, y, x + w, y + sh, x + w - 1.0, y + sh - 1.0 * p2, x + w - 1.0, y + 1.0, -16777216, colour);
                this.drawGradientQuad(buffer, mat, x + w - 1.0, y + 1.0, x + w - 1.0, y + sh - 1.0, x + w - 2.0, y + sh - 2.0 * p2, x + w - 2.0, y + 2.0, colour, -16777216);
            }
            if (bp - w - h > 0.0) {
                sw = Math.min(w, bp - w - h);
                double sx = x + w - sw;
                p = sw / w;
                this.drawGradientQuad(buffer, mat, sx + 2.0 * p, y + h - 2.0, sx + sw - 2.0, y + h - 2.0, sx + sw - 1.0, y + h - 1.0, sx + 1.0, y + h - 1.0, -16777216, colour);
                this.drawGradientQuad(buffer, mat, sx + 1.0 * p, y + h - 1.0, sx + sw - 1.0, y + h - 1.0, sx + sw, y + h, sx, y + h, colour, -16777216);
            }
            if (bp - w - h - w > 0.0) {
                sh = Math.min(h, bp - w - h - w);
                double sy = y + h - sh;
                p = sh / h;
                this.drawGradientQuad(buffer, mat, x + 1.0, sy + 1.0 * p, x + 1.0, sy + sh - 1.0, x, sy + sh, x, sy, colour, -16777216);
                this.drawGradientQuad(buffer, mat, x + 2.0, sy + 2.0 * p, x + 2.0, sy + sh - 2.0, x + 1.0, sy + sh - 1.0, x + 1.0, sy + 1.0 * p, -16777216, colour);
            }
            render.flush();
        }

        private void drawGradientQuad(VertexConsumer buffer, Matrix4f mat, double p1A, double p1B, double p2A, double p2B, double p3A, double p3B, double p4A, double p4B, int startColor, int endColor) {
            if (startColor == endColor && endColor == 0) {
                return;
            }
            float startAlpha = (float)(startColor >> 24 & 0xFF) / 255.0f;
            float startRed = (float)(startColor >> 16 & 0xFF) / 255.0f;
            float startGreen = (float)(startColor >> 8 & 0xFF) / 255.0f;
            float startBlue = (float)(startColor & 0xFF) / 255.0f;
            float endAlpha = (float)(endColor >> 24 & 0xFF) / 255.0f;
            float endRed = (float)(endColor >> 16 & 0xFF) / 255.0f;
            float endGreen = (float)(endColor >> 8 & 0xFF) / 255.0f;
            float endBlue = (float)(endColor & 0xFF) / 255.0f;
            buffer.m_252986_(mat, (float)p4A, (float)p4B, 0.0f).m_85950_(endRed, endGreen, endBlue, endAlpha).m_5752_();
            buffer.m_252986_(mat, (float)p3A, (float)p3B, 0.0f).m_85950_(endRed, endGreen, endBlue, endAlpha).m_5752_();
            buffer.m_252986_(mat, (float)p2A, (float)p2B, 0.0f).m_85950_(startRed, startGreen, startBlue, startAlpha).m_5752_();
            buffer.m_252986_(mat, (float)p1A, (float)p1B, 0.0f).m_85950_(startRed, startGreen, startBlue, startAlpha).m_5752_();
        }
    }

    public static class Screen
    extends ModularGuiScreen {
        public Screen() {
            super((GuiProvider)new HudConfigGui());
        }
    }
}

