/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.tool.terrasteel;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.item.SequentialBreaker;
import vazkii.botania.api.mana.ManaBarTooltip;
import vazkii.botania.api.mana.ManaItem;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.helper.PlayerHelper;
import vazkii.botania.common.item.CustomCreativeTabContents;
import vazkii.botania.common.item.StoneOfTemperanceItem;
import vazkii.botania.common.item.equipment.tool.ToolCommons;
import vazkii.botania.common.item.equipment.tool.manasteel.ManasteelPickaxeItem;
import vazkii.botania.common.item.relic.RingOfThorItem;
import vazkii.botania.common.lib.BotaniaTags;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.xplat.XplatAbstractions;

public class TerraShattererItem
extends ManasteelPickaxeItem
implements SequentialBreaker,
CustomCreativeTabContents {
    private static final String TAG_ENABLED = "enabled";
    private static final String TAG_MANA = "mana";
    private static final String TAG_TIPPED = "tipped";
    private static final int MAX_MANA = Integer.MAX_VALUE;
    private static final int MANA_PER_DAMAGE = 100;
    public static final int[] LEVELS = new int[]{0, 10000, 1000000, 10000000, 100000000, 1000000000};
    private static final int[] CREATIVE_MANA = new int[]{9999, 999999, 9999999, 99999999, 999999999, 0x7FFFFFFE};

    public TerraShattererItem(Item.Properties props) {
        super(BotaniaAPI.instance().getTerrasteelItemTier(), props, -2.8f);
    }

    @Override
    public void addToCreativeTab(Item me, CreativeModeTab.Output output) {
        output.m_246326_((ItemLike)this);
        for (int mana : CREATIVE_MANA) {
            ItemStack stack = new ItemStack((ItemLike)this);
            TerraShattererItem.setMana(stack, mana);
            output.m_246342_(stack);
        }
        ItemStack stack = new ItemStack((ItemLike)this);
        TerraShattererItem.setMana(stack, CREATIVE_MANA[1]);
        TerraShattererItem.setTipped(stack);
        output.m_246342_(stack);
    }

    public void m_7373_(ItemStack stack, Level world, List<Component> stacks, TooltipFlag flags) {
        MutableComponent rank = Component.m_237115_((String)("botania.rank" + TerraShattererItem.getLevel(stack)));
        MutableComponent rankFormat = Component.m_237110_((String)"botaniamisc.toolRank", (Object[])new Object[]{rank});
        stacks.add((Component)rankFormat);
        ManaItem manaItem = XplatAbstractions.INSTANCE.findManaItem(stack);
        if (manaItem != null && manaItem.getMana() == Integer.MAX_VALUE) {
            stacks.add((Component)Component.m_237115_((String)"botaniamisc.getALife").m_130940_(ChatFormatting.RED));
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (player.m_36341_() && hand == InteractionHand.MAIN_HAND) {
            int tier = TerraShattererItem.getLevel(stack);
            BlockHitResult blockhitresult = TerraShattererItem.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
            if (tier != 0 && blockhitresult.m_6662_() != HitResult.Type.BLOCK) {
                this.setEnabled(stack, !TerraShattererItem.isEnabled(stack));
                if (!level.f_46443_) {
                    level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), BotaniaSounds.terraPickMode, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
                return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.m_5776_());
            }
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    @Override
    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        super.m_6883_(stack, world, entity, slot, selected);
        if (TerraShattererItem.isEnabled(stack)) {
            int level = TerraShattererItem.getLevel(stack);
            if (level == 0) {
                this.setEnabled(stack, false);
            } else if (entity instanceof Player) {
                Player player = (Player)entity;
                if (!player.f_20911_) {
                    ManaItem manaItem = XplatAbstractions.INSTANCE.findManaItem(stack);
                    manaItem.addMana(-level);
                }
            }
        }
    }

    public Optional<TooltipComponent> m_142422_(ItemStack stack) {
        int level = TerraShattererItem.getLevel(stack);
        int max = LEVELS[Math.min(LEVELS.length - 1, level + 1)];
        int curr = TerraShattererItem.getMana_(stack);
        float percent = level == 0 ? 0.0f : (float)curr / (float)max;
        return Optional.of(new ManaBarTooltip(percent, level));
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, Player player) {
        BlockHitResult raycast = ToolCommons.raytraceFromEntity((Entity)player, 10.0, false);
        if (!player.m_9236_().f_46443_ && raycast.m_6662_() == HitResult.Type.BLOCK) {
            Direction face = raycast.m_82434_();
            this.breakOtherBlock(player, stack, pos, pos, face);
            if (player.m_36341_()) {
                BotaniaAPI.instance().breakOnAllCursors(player, stack, pos, face);
            }
        }
        return false;
    }

    @Override
    public int getManaPerDamage() {
        return 100;
    }

    @Override
    public void breakOtherBlock(Player player, ItemStack stack, BlockPos pos, BlockPos originPos, Direction side) {
        if (!TerraShattererItem.isEnabled(stack)) {
            return;
        }
        Predicate<BlockState> canMine = state -> {
            boolean rightToolForDrops = !state.m_60834_() || stack.m_41735_(state);
            boolean rightToolForSpeed = stack.m_41691_(state) > 1.0f || state.m_204336_(BlockTags.f_144283_) || state.m_204336_(BlockTags.f_144281_);
            return rightToolForDrops && rightToolForSpeed;
        };
        Level world = player.m_9236_();
        BlockState targetState = world.m_8055_(pos);
        if (!canMine.test(targetState)) {
            return;
        }
        if (world.m_46859_(pos)) {
            return;
        }
        boolean thor = !RingOfThorItem.getThorRing(player).m_41619_();
        boolean doX = thor || side.m_122429_() == 0;
        boolean doY = thor || side.m_122430_() == 0;
        boolean doZ = thor || side.m_122431_() == 0;
        int origLevel = TerraShattererItem.getLevel(stack);
        int level = origLevel + (thor ? 1 : 0);
        if (StoneOfTemperanceItem.hasTemperanceActive(player) && level > 2) {
            level = 2;
        }
        int range = level - 1;
        int rangeY = Math.max(1, range);
        if (range == 0 && level != 1) {
            return;
        }
        Vec3i beginDiff = new Vec3i(doX ? -range : 0, doY ? -1 : 0, doZ ? -range : 0);
        Vec3i endDiff = new Vec3i(doX ? range : 0, doY ? rangeY * 2 - 1 : 0, doZ ? range : 0);
        ToolCommons.removeBlocksInIteration(player, stack, world, pos, beginDiff, endDiff, canMine);
        if (origLevel == 5) {
            PlayerHelper.grantCriterion((ServerPlayer)player, ResourceLocationHelper.prefix("challenge/rank_ss_pick"), "code_triggered");
        }
    }

    public static boolean isTipped(ItemStack stack) {
        return ItemNBTHelper.getBoolean(stack, TAG_TIPPED, false);
    }

    public static void setTipped(ItemStack stack) {
        ItemNBTHelper.setBoolean(stack, TAG_TIPPED, true);
    }

    public static boolean isEnabled(ItemStack stack) {
        return ItemNBTHelper.getBoolean(stack, TAG_ENABLED, false);
    }

    void setEnabled(ItemStack stack, boolean enabled) {
        ItemNBTHelper.setBoolean(stack, TAG_ENABLED, enabled);
    }

    protected static void setMana(ItemStack stack, int mana) {
        if (mana > 0) {
            ItemNBTHelper.setInt(stack, TAG_MANA, mana);
        } else {
            ItemNBTHelper.removeEntry(stack, TAG_MANA);
        }
    }

    public static int getMana_(ItemStack stack) {
        return ItemNBTHelper.getInt(stack, TAG_MANA, 0);
    }

    public static int getLevel(ItemStack stack) {
        int mana = TerraShattererItem.getMana_(stack);
        for (int i = LEVELS.length - 1; i > 0; --i) {
            if (mana < LEVELS[i]) continue;
            return i;
        }
        return 0;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return this.reequipAnimation(oldStack, newStack);
    }

    public boolean allowNbtUpdateAnimation(Player player, InteractionHand hand, ItemStack before, ItemStack after) {
        return this.reequipAnimation(before, after);
    }

    private boolean reequipAnimation(ItemStack before, ItemStack after) {
        return !after.m_150930_((Item)this) || TerraShattererItem.isEnabled(before) != TerraShattererItem.isEnabled(after);
    }

    @NotNull
    public Rarity m_41460_(@NotNull ItemStack stack) {
        int level = TerraShattererItem.getLevel(stack);
        if (stack.m_41793_()) {
            ++level;
        }
        if (level >= 5) {
            return Rarity.EPIC;
        }
        if (level >= 3) {
            return Rarity.RARE;
        }
        return Rarity.UNCOMMON;
    }

    public static class ManaItemImpl
    implements ManaItem {
        private final ItemStack stack;

        public ManaItemImpl(ItemStack stack) {
            this.stack = stack;
        }

        @Override
        public int getMana() {
            return TerraShattererItem.getMana_(this.stack) * this.stack.m_41613_();
        }

        @Override
        public int getMaxMana() {
            return Integer.MAX_VALUE * this.stack.m_41613_();
        }

        @Override
        public void addMana(int mana) {
            TerraShattererItem.setMana(this.stack, Math.min(this.getMana() + mana, this.getMaxMana()) / this.stack.m_41613_());
        }

        @Override
        public boolean canReceiveManaFromPool(BlockEntity pool) {
            return true;
        }

        @Override
        public boolean canReceiveManaFromItem(ItemStack otherStack) {
            return !otherStack.m_204117_(BotaniaTags.Items.TERRA_PICK_BLACKLIST);
        }

        @Override
        public boolean canExportManaToPool(BlockEntity pool) {
            return false;
        }

        @Override
        public boolean canExportManaToItem(ItemStack otherStack) {
            return false;
        }

        @Override
        public boolean isNoExport() {
            return true;
        }
    }
}

