/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.api.corporea;

import java.util.Collections;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.ServiceUtil;
import vazkii.botania.api.corporea.CorporeaNode;
import vazkii.botania.api.corporea.CorporeaRequestMatcher;
import vazkii.botania.api.corporea.CorporeaResult;
import vazkii.botania.api.corporea.CorporeaSpark;

public interface CorporeaHelper {
    public static final CorporeaHelper INSTANCE = ServiceUtil.findService(CorporeaHelper.class, () -> new CorporeaHelper(){});

    public static CorporeaHelper instance() {
        return INSTANCE;
    }

    default public Set<CorporeaNode> getNodesOnNetwork(CorporeaSpark spark) {
        return Collections.emptySet();
    }

    default public CorporeaRequestMatcher createMatcher(ItemStack stack, boolean checkNBT) {
        return CorporeaRequestMatcher.Dummy.INSTANCE;
    }

    default public CorporeaRequestMatcher createMatcher(String name) {
        return CorporeaRequestMatcher.Dummy.INSTANCE;
    }

    default public CorporeaResult requestItem(CorporeaRequestMatcher matcher, int itemCount, CorporeaSpark spark, @Nullable LivingEntity requestor, boolean doit) {
        return CorporeaResult.Dummy.INSTANCE;
    }

    @Nullable
    default public CorporeaSpark getSparkForBlock(Level world, BlockPos pos) {
        return null;
    }

    default public boolean doesBlockHaveSpark(Level world, BlockPos pos) {
        return this.getSparkForBlock(world, pos) != null;
    }

    default public int signalStrengthForRequestSize(int requestSize) {
        return 0;
    }

    default public <T extends CorporeaRequestMatcher> void registerRequestMatcher(ResourceLocation id, Class<T> clazz, Function<CompoundTag, T> deserializer) {
    }
}

